<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

/**
 * Class LiteBackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class LiteBackendStrings
{
    /**
     * Returns the array for the common strings
     *
     * @return array
     */
    public static function getCommonStrings()
    {
        return [
            'admin'                     => __('Admin', 'ameliabooking'),
            'add_date'                  => __('Add Date', 'ameliabooking'),
            'add_language'              => __('Add Language', 'ameliabooking'),
            'add_period'                => __('Add Period', 'ameliabooking'),
            'all_services'              => __('All Services', 'ameliabooking'),
            'appointment'               => __('Appointment', 'ameliabooking'),
            'appointments'              => __('Appointments', 'ameliabooking'),
            'approved'                  => __('Approved', 'ameliabooking'),
            'attendee'                  => __('Attendee', 'ameliabooking'),
            'booked'                    => __('Booked', 'ameliabooking'),
            'bookings'                  => __('Bookings', 'ameliabooking'),
            'cancel'                    => __('Cancel', 'ameliabooking'),
            'canceled'                  => __('Canceled', 'ameliabooking'),
            'capacity'                  => __('Spots', 'ameliabooking'),
            'content_mode_tooltip'      => __('Don\'t use Text mode option if you already have HTML code in the description, since once this option is enabled the existing HTML tags could be lost.', 'ameliabooking'),
            'close'                     => __('Close', 'ameliabooking'),
            'closed'                    => __('Closed', 'ameliabooking'),
            'csv_delimiter'             => __('Select Delimiter', 'ameliabooking'),
            'csv_delimiter_comma'       => __('Comma (,)', 'ameliabooking'),
            'continue'                  => __('Continue', 'ameliabooking'),
            'coupon_code'               => __('Coupon code', 'ameliabooking'),
            'customer'                  => __('Customer', 'ameliabooking'),
            'minutes'                   => __('Minutes', 'ameliabooking'),
            'hour'                      => __('Hour', 'ameliabooking'),
            'hours'                     => __('Hours', 'ameliabooking'),
            'day'                       => __('Day', 'ameliabooking'),
            'days'                      => __('Days', 'ameliabooking'),
            'week'                      => __('Week', 'ameliabooking'),
            'weeks'                     => __('Weeks', 'ameliabooking'),
            'month'                     => __('Month', 'ameliabooking'),
            'months'                    => __('Months', 'ameliabooking'),
            'year'                      => __('Year', 'ameliabooking'),
            'years'                     => __('Years', 'ameliabooking'),
            'date'                      => __('Date', 'ameliabooking'),
            'delete'                    => __('Delete', 'ameliabooking'),
            'description'               => __('Description', 'ameliabooking'),
            'details'                   => __('Details', 'ameliabooking'),
            'disabled'                  => __('Disabled', 'ameliabooking'),
            'duration'                  => __('Duration', 'ameliabooking'),
            'duplicate'                 => __('Duplicate', 'ameliabooking'),
            'edit'                      => __('Edit', 'ameliabooking'),
            'email_placeholder'         => __('example@mail.com', 'ameliabooking'),
            'employee'                  => __('Employee', 'ameliabooking'),
            'employees'                 => __('Employees', 'ameliabooking'),
            'employee_badge'            => __('Employee Badge', 'ameliabooking'),
            'employee_badges'           => __('Employee Badges', 'ameliabooking'),
            'enable_google_social_login' => __('Enable Google Login', 'ameliabooking'),
            'enable_facebook_social_login' => __('Enable Facebook Login', 'ameliabooking'),
            'facebook_app_id_required'  => __('Facebook App ID is required', 'ameliabooking'),
            'facebook_app_secret_required' => __('Facebook App Secret is required', 'ameliabooking'),
            'enter_email_warning'       => __('Please enter email', 'ameliabooking'),
            'enter_valid_email_warning' => __('Please enter a valid email address', 'ameliabooking'),
            'error'                     => __('Error', 'ameliabooking'),
            'event'                     => __('Event', 'ameliabooking'),
            'events'                    => __('Events', 'ameliabooking'),
            'export'                    => __('Export', 'ameliabooking'),
            'extra'                     => __('Extra', 'ameliabooking'),
            'extras'                    => __('Extras', 'ameliabooking'),
            'extras_total_price'        => __('Extras total price', 'ameliabooking'),
            'google_calendar'           => __('Google Calendar', 'ameliabooking'),
            'google_meet_join'          => __('Join With Google Meet', 'ameliabooking'),
            'outlook_calendar'          => __('Outlook Calendar', 'ameliabooking'),
            'microsoft_teams_join'      => __('Join With Microsoft Teams', 'ameliabooking'),
            'apple_calendar'            => __('Apple Calendar', 'ameliabooking'),
            'h'                         => __('h', 'ameliabooking'),
            'id'                        => __('ID', 'ameliabooking'),
            'language'                  => __('Language', 'ameliabooking'),
            'lesson_space'              => __('Lesson Space', 'ameliabooking'),
            'licence_description'       => __('Interested in unlocking this feature?', 'ameliabooking'),
            'licence_start_description' => __('Available from Starter license', 'ameliabooking'),
            'licence_basic_description' => __('Available from Standard license', 'ameliabooking'),
            'licence_pro_description'   => __('Available from Pro license', 'ameliabooking'),
            'licence_dev_description'   => __('Available in Elite licence', 'ameliabooking'),
            'licence_button_text'       => __('Upgrade', 'ameliabooking'),
            'delete_amelia_short'       => __('Delete Amelia content', 'ameliabooking'),
            'delete_amelia'             => __('Delete tables, roles, files and settings once the Amelia plugin is deleted.', 'ameliabooking'),
            'delete_amelia_tooltip'     => __('Enable this option if you want to delete plugin tables, roles, files and settings<br>when deleting the plugin from plugins page', 'ameliabooking'),
            'appointment_space_name'    => __('Appointment Space Name', 'ameliabooking'),
            'event_space_name'          => __('Event Space Name', 'ameliabooking'),
            'lesson_space_join'         => __('Join Space', 'ameliabooking'),
            'lesson_space_pending'      => __('Create spaces for pending appointments', 'ameliabooking'),
            'limit_extra_people'        => __('Limit the additional number of people', 'ameliabooking'),
            'limit_extra_people_set'    => __('Set Limit', 'ameliabooking'),
            'limit_extra_people_tooltip'=> __('Limit the number of people that one customer can add during the booking', 'ameliabooking'),
            'lite_vs_premium'           => __('Lite vs Premium', 'ameliabooking'),
            'location'                  => __('Location', 'ameliabooking'),
            'locations'                 => __('Locations', 'ameliabooking'),
            'manage'                    => __('Manage', 'ameliabooking'),
            'min'                       => __('min', 'ameliabooking'),
            'measurement_id'            => __('Measurement ID', 'ameliabooking'),
            'name'                      => __('Name', 'ameliabooking'),
            'enter_name_warning'        => __('Please enter name', 'ameliabooking'),
            'name_ascending'            => __('Name Ascending', 'ameliabooking'),
            'name_descending'           => __('Name Descending', 'ameliabooking'),
            'need_help'                 => __('Need Help', 'ameliabooking'),
            'no'                        => __('No', 'ameliabooking'),
            'no_results'                => __('There are no results...', 'ameliabooking'),
            'no_packages_yet'           => __('You don\'t have any packages here yet...', 'ameliabooking'),
            'no_resources_yet'          => __('You don\'t have any resources yet...', 'ameliabooking'),
            'no_services_yet'           => __('You don\'t have any services here yet...', 'ameliabooking'),
            'no-show'                   => __('No-show', 'ameliabooking'),
            'note'                      => __('Note', 'ameliabooking'),
            'note_internal'             => __('Note (Internal)', 'ameliabooking'),
            'notifications'             => __('Notification', 'ameliabooking'),
            'ok'                        => __('OK', 'ameliabooking'),
            'of'                        => __('of', 'ameliabooking'),
            'on_site'                   => __('On-site', 'ameliabooking'),
            'opened'                    => __('Opened', 'ameliabooking'),
            'open'                      => __('Open', 'ameliabooking'),
            'out_of'                    => __('out of', 'ameliabooking'),
            'packages'                  => __('Packages', 'ameliabooking'),
            'paid'                      => __('Paid', 'ameliabooking'),
            'partially_paid'            => __('Partially Paid', 'ameliabooking'),
            'payment'                   => __('Payment', 'ameliabooking'),
            'payment_amount'            => __('Payment Amount', 'ameliabooking'),
            'payment_method'            => __('Payment Method', 'ameliabooking'),
            'payment_status'            => __('Payment Status', 'ameliabooking'),
            'payment_tooltip'           => __('If all payment methods are disabled on the service/event,<br/>the default payment method will be used.', 'ameliabooking'),
            'pdf'                       => __('PDF', 'ameliabooking'),
            'pending'                   => __('Pending', 'ameliabooking'),
            'phone'                     => __('Phone', 'ameliabooking'),
            'rejected'                  => __('Rejected', 'ameliabooking'),
            'resources'                 => __('Resources', 'ameliabooking'),
            'save'                      => __('Save', 'ameliabooking'),
            'select_badge'              => __('Select badge', 'ameliabooking'),
            'select_date_warning'       => __('Please select date', 'ameliabooking'),
            'select_time_warning'       => __('Please select time', 'ameliabooking'),
            'service'                   => __('Service', 'ameliabooking'),
            'services'                  => __('Services', 'ameliabooking'),
            'settings_saved'            => __('Settings has been saved', 'ameliabooking'),
            'showing'                   => __('Showing', 'ameliabooking'),
            'social_login'              => __('Social Login', 'ameliabooking'),
            'status'                    => __('Status', 'ameliabooking'),
            'status_colon'              => __('Status:', 'ameliabooking'),
            'success'                   => __('Success', 'ameliabooking'),
            'text_mode'                 => __('Text Mode', 'ameliabooking'),
            'html_mode'                 => __('HTML Mode', 'ameliabooking'),
            'tag'                       => __('Tag', 'ameliabooking'),
            'to'                        => __('to', 'ameliabooking'),
            'today'                     => __('Today', 'ameliabooking'),
            'tomorrow'                  => __('Tomorrow', 'ameliabooking'),
            'total'                     => __('Total', 'ameliabooking'),
            'translate'                 => __('Translate', 'ameliabooking'),
            'translation'               => __('Translation', 'ameliabooking'),
            'view'                      => __('View', 'ameliabooking'),
            'weekday_friday'            => __('Friday', 'ameliabooking'),
            'weekday_monday'            => __('Monday', 'ameliabooking'),
            'weekday_saturday'          => __('Saturday', 'ameliabooking'),
            'weekday_sunday'            => __('Sunday', 'ameliabooking'),
            'weekday_thursday'          => __('Thursday', 'ameliabooking'),
            'weekday_tuesday'           => __('Tuesday', 'ameliabooking'),
            'weekday_wednesday'         => __('Wednesday', 'ameliabooking'),
            'yes'                       => __('Yes', 'ameliabooking'),
            'zoom'                      => __('Zoom', 'ameliabooking'),
            'zoom_click_to_join'        => __('Join Zoom Meeting', 'ameliabooking'),
            'zoom_click_to_start'       => __('Start Zoom Meeting', 'ameliabooking'),
            'view_grid'                 => __('Grid View', 'ameliabooking'),
            'view_table'                => __('Table View', 'ameliabooking'),
            'view_list'                 => __('List View', 'ameliabooking'),
            'view_group'                => __('Group View', 'ameliabooking'),
            'whats_new'                 => __('What\'s new', 'ameliabooking'),
            'layout_select_label'       => __('Choose layout version', 'ameliabooking'),
            'layout_dropdown'           => __('Dropdown layout', 'ameliabooking'),
            'layout_list'               => __('List layout', 'ameliabooking'),
            'layout_description'        => __('Choosing layout of first step in step by step form', 'ameliabooking'),
            'new_caps'                  => __('NEW', 'ameliabooking'),
            'xml'                       => __('XML', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the settings strings
     *
     * @return array
     */
    public static function getSettingsStrings()
    {
        return [
            '1year'                                  => __('1 year', 'ameliabooking'),
            'activate'                               => __('Activate', 'ameliabooking'),
            'activation'                             => __('Activation', 'ameliabooking'),
            'activation_settings'                    => __('Activation Settings', 'ameliabooking'),
            'activation_settings_description'        => __('Use this setting to activate the plugin code so you can have access to auto updates of Amelia', 'ameliabooking'),
            'activation_settings_explanation'        => __('Activate the plugin by entering Purchase code or using Envato API.', 'ameliabooking'),
            'add_web_hook'                           => __('Add New Web Hook', 'ameliabooking'),
            'add_to_calendar'                        => __('Show Add To Calendar option to customers', 'ameliabooking'),
            'add_to_calendar_tooltip'                => __('Suggest customers to add an appointment to their calendar<br/>when booking is finalized.', 'ameliabooking'),
            'address'                                => __('Address', 'ameliabooking'),
            'after'                                  => __('After', 'ameliabooking'),
            'after_with_space'                       => __('After with space', 'ameliabooking'),
            'allow_booking_if_pending_tooltip'       => __('If this is disabled, your front-end customers won\'t be able to book appointment with Pending status above the maximum capacity.<br/>Once the maximum capacity is reached appointment will close and time slot will become unavailable.', 'ameliabooking'),
            'allow_booking_if_not_min_tooltip'       => __('If this is disabled, your front-end customers won\'t be able to submit a booking unless they fill in the minimum service capacity,<br/>but once they book for any capacity above minimum, the time slot will become unavailable for booking for others.<br/>If enabled, multiple customers will be able to book the same time slot, without having to fill in the minimum capacity.', 'ameliabooking'),
            'allow_booking_if_not_min'               => __('Allow booking below minimum capacity', 'ameliabooking'),
            'allow_admin_book_at_any_time'           => __('Allow admin to book appointment at any time', 'ameliabooking'),
            'allow_admin_book_over_app'              => __('Allow admin to book over an existing appointment', 'ameliabooking'),
            'allow_admin_book_at_any_time_tooltip'   => __('If you enable this option, Admin will be able to book appointment at any time<br>(working hours, special days and days off for all employees will be ignored).', 'ameliabooking'),
            'allow_admin_book_over_app_tooltip'      => __('If you enable this option, Admin will be able to book appointment over or during<br>another appointment.', 'ameliabooking'),
            'allow_configure_days_off'               => __('Configure their days off', 'ameliabooking'),
            'allow_configure_services'               => __('Configure their services', 'ameliabooking'),
            'allow_configure_schedule'               => __('Configure their schedule', 'ameliabooking'),
            'allow_configure_special_days'           => __('Configure their special days', 'ameliabooking'),
            'allow_booking_if_pending'               => __('Allow booking above maximum capacity', 'ameliabooking'),
            'allow_customer_reschedule'              => __('Allow customers to reschedule their own appointments', 'ameliabooking'),
            'allow_customer_reschedule_tooltip'      => __('Enable this option if you want to allow your customers to reschedule their own appointments.', 'ameliabooking'),
            'allow_customer_delete_profile'          => __('Allow customers to delete their profile', 'ameliabooking'),
            'allow_customer_cancel_packages'         => __('Allow customers to cancel packages', 'ameliabooking'),
            'allow_write_appointments'               => __('Manage their appointments', 'ameliabooking'),
            'allow_write_events'                     => __('Manage their events', 'ameliabooking'),
            'allow_write_customers'                  => __('Manage customers', 'ameliabooking'),
            'api_documentation'                      => __('Amelia API Documentation', 'ameliabooking'),
            'api_keys'                               => __('API keys', 'ameliabooking'),
            'api_keys_settings_description'          => __('Use this setting to manage API keys for Amelia endpoints', 'ameliabooking'),
            'api_key_placeholder'                    => __('Click \'Generate\' to get your API key', 'ameliabooking'),
            'api_url'                                => __('API base URL: ', 'ameliabooking'),
            'appointments_and_events'                => __('Appointments and Events', 'ameliabooking'),
            'appointments_and_events_settings'       => __('Appointments and Events Settings', 'ameliabooking'),
            'appointments_settings_description'      => __('Use these settings to manage frontend bookings', 'ameliabooking'),
            'maximum_capacity'                       => __('Maximum Capacity', 'ameliabooking'),
            'waiting_list_limit_per_person'          => __('Limit number of tickets per person', 'ameliabooking'),
            'waiting_list'                           => __('Waiting list', 'ameliabooking'),
            'waiting'                                => __('Waiting', 'ameliabooking'),
            'waiting_list_adding_method'             => __('Handle the way of adding people from Waiting List', 'ameliabooking'),
            'waiting_list_adding_method_auto'        => __('Automatically', 'ameliabooking'),
            'waiting_list_adding_method_manual'      => __('Manually', 'ameliabooking'),
            'waiting_list_adding_method_auto_tt'     => __('Once the booking has been canceled or rejected the new attendee will be automatically moved from waiting list to the scheduled event', 'ameliabooking'),
            'waiting_list_adding_method_manual_tt'   => __('Admin or employee will need to manually change the status on the waiting list to move the customer/attendee to the scheduled event', 'ameliabooking'),
            'events_show_waiting_list_booking_full'  => __('Show waiting list after booking is full', 'ameliabooking'),
            'approve_appointment_success_url'        => __('Redirect URL for Successfully Approved Booking', 'ameliabooking'),
            'approve_appointment_error_url'          => __('Redirect URL for Unsuccessfully Approved Booking', 'ameliabooking'),
            'automatically_create_customer'          => __('Automatically create Amelia Customer user', 'ameliabooking'),
            'automatically_create_customer_tooltip'  => __('If you enable this option every time a new customer schedules the appointment<br/>he will get Amelia Customer user role and automatic email with login details.', 'ameliabooking'),
            'back_links'                             => __('Support Amelia by enabling this option', 'ameliabooking'),
            'back_links_tooltip'                     => __('Allow the short description below the booking form to support<br/>Amelia Booking Plugin and spread the word about it.', 'ameliabooking'),
            'bcc_email'                              => __('Send all notifications to additional addresses', 'ameliabooking'),
            'bcc_email_tooltip'                      => __('Here you can enter additional email addresses where all notifications will be sent.<br/>To add an address click Enter.', 'ameliabooking'),
            'bcc_sms'                                => __('Send all SMS messages to additional numbers', 'ameliabooking'),
            'bcc_sms_tooltip'                        => __('Here you can enter additional phone numbers where all SMS messages will be sent.<br/>To add a number click Enter.', 'ameliabooking'),
            'before'                                 => __('Before', 'ameliabooking'),
            'before_with_space'                      => __('Before with space', 'ameliabooking'),
            'bringing_anyone_logic'                  => __('Logic for Counting People:', 'ameliabooking'),
            'bringing_anyone_logic_additional'       => __('Customer plus Additional People', 'ameliabooking'),
            'bringing_anyone_logic_additional_tt'    => __('Select this option to count the total number of persons as the primary customer plus any additional people.', 'ameliabooking'),
            'bringing_anyone_logic_total'            => __('Total Number of People', 'ameliabooking'),
            'bringing_anyone_logic_total_tt'         => __('Select this option to count the total number of persons directly, including the primary customer.', 'ameliabooking'),
            'buffer_time_in_slot'                    => __('Include service buffer time in time slots', 'ameliabooking'),
            'buffer_time_in_slot_tooltip'            => __('If this option is enabled<br>time slots will be shown with included service buffer time', 'ameliabooking'),
            'coupons_case_insensitive'               => __('Set Coupons to be case insensitive', 'ameliabooking'),
            'calendar'                               => __('Calendar', 'ameliabooking'),
            'cancel_error_url'                       => __('Unsuccessful Cancellation Redirect URL', 'ameliabooking'),
            'cancel_error_url_tooltip'               => __('URL on which will user be redirected if appointment can\'t be canceled<br/>because of \'Minimum time required before canceling\' value', 'ameliabooking'),
            'cancel_success_url'                     => __('Successful Cancellation Redirect URL', 'ameliabooking'),
            'cancel_url_placeholder'                 => __('Please enter URL', 'ameliabooking'),
            'comma_dot'                              => __('Comma-Dot', 'ameliabooking'),
            'company'                                => __('Company', 'ameliabooking'),
            'company_settings'                       => __('Company Settings', 'ameliabooking'),
            'company_settings_description'           => __('Use these settings to set up picture, name, address, phone and website of your company', 'ameliabooking'),
            'country'                                => __('Country', 'ameliabooking'),
            'cart_enable'                            => __('Cart', 'ameliabooking'),
            'cart_enable_tooltip'                    => __('If this option is enabled, customers will be able to book multiple services in a single booking process.', 'ameliabooking'),
            'coupons'                                => __('Coupons', 'ameliabooking'),
            'description_barion'                     => __('Description for Barion', 'ameliabooking'),
            'enable_no_show_tag'                     => __('Enable No-show tag', 'ameliabooking'),
            'enable_no_show_tag_tooltip'             => __('Enable this option if you want to see which Customers were a No-show', 'ameliabooking'),
            'description_square'                     => __('Description for Square', 'ameliabooking'),
            'enable_google_meet'                     => __('Enable Google Meet', 'ameliabooking'),
            'enable_microsoft_teams'                 => __('Enable Microsoft Teams', 'ameliabooking'),
            'facebook_pixel'                         => __('Facebook Pixel', 'ameliabooking'),
            'google_universal_analytics'             => __('Google Universal Analytics', 'ameliabooking'),
            'google_analytics'                       => __('Google Analytics', 'ameliabooking'),
            'generate'                               => __('Generate', 'ameliabooking'),
            'employee_selection_logic'               => __('Employee selection logic', 'ameliabooking'),
            'employee_selection_logic_random'        => __('Random', 'ameliabooking'),
            'currency'                               => __('Currency', 'ameliabooking'),
            'customize_page'                         => __('Customize Page', 'ameliabooking'),
            'customers_as_attendees'                 => __('Add Event\'s Attendees', 'ameliabooking'),
            'customer_cabinet'                       => __('Customer Panel Page URL', 'ameliabooking'),
            'employee_cabinet'                       => __('Employee Panel Page URL', 'ameliabooking'),
            'enable_qr_code'                         => __('Enable QR code E-Tickets', 'ameliabooking'),
            'events_qr_code_notice_title'            => __('Send notification to users with QR Code E-Tickets', 'ameliabooking'),
            'events_qr_code_notice_subtitle'         => __('You need to set up a QR Code E-Tickets notification.', 'ameliabooking'),
            'events_qr_code_notice_btn_text'         => __('Set Notification', 'ameliabooking'),
            'enable_waiting_list'                    => __('Enable Waiting List', 'ameliabooking'),
            'events_show_waiting_list_slots'         => __('Show waiting list slots', 'ameliabooking'),
            'events_waiting_list_notice_title'       => __('Notify the users in waiting lists', 'ameliabooking'),
            'events_waiting_list_notice_subtitle'    => __('You need to set up a Waiting List notification.', 'ameliabooking'),
            'events_waiting_list_notice_btn_text'    => __('Set Notification', 'ameliabooking'),
            'default_appointment_status'             => __('Default Appointment Status', 'ameliabooking'),
            'default_appointment_status_tooltip'     => __('All appointments will be scheduled with the<br/>status you choose here.', 'ameliabooking'),
            'default_items_per_page'                 => __('Default items per page for Frontend', 'ameliabooking'),
            'default_items_per_page_backend'         => __('Default items per page for Backend', 'ameliabooking'),
            'default_page_on_backend'                => __('Default page on back-end', 'ameliabooking'),
            'default_payment_method'                 => __('Default Payment Method', 'ameliabooking'),
            'default_phone_country_code'             => __('Default phone country code', 'ameliabooking'),
            'default_time_slot_step'                 => __('Default Time Slot Step', 'ameliabooking'),
            'default_time_slot_step_tooltip'         => __('The Time Slot Step you define here will be applied<br/>for all time slots in the plugin.', 'ameliabooking'),
            'dot_comma'                              => __('Dot-Comma', 'ameliabooking'),
            'enable_labels_settings'                 => __('Enable Labels Settings', 'ameliabooking'),
            'enable_labels_settings_tooltip'         => __('Disable this option if you want to translate these<br/>strings using the third party translation plugin.', 'ameliabooking'),
            'enable_customer_cabinet'                => __('Enable Customer Panel', 'ameliabooking'),
            'enable_employee_cabinet'                => __('Enable Employee Panel', 'ameliabooking'),
            'enable_polyfill'                        => __('Enable usage for older IE browsers', 'ameliabooking'),
            'see_unavailable_features'               => __('Hide locked options', 'ameliabooking'),
            'envato_api'                             => __('Envato API', 'ameliabooking'),
            'envato_api_activate'                    => __('Activate with Envato', 'ameliabooking'),
            'event_title_and_description'            => __('Event Title and Description', 'ameliabooking'),
            'events'                                 => __('Events', 'ameliabooking'),
            'mailchimp'                              => __('Mailchimp', 'ameliabooking'),
            'meeting_title'                          => __('Meeting Title', 'ameliabooking'),
            'meeting_agenda'                         => __('Meeting Agenda', 'ameliabooking'),
            'facebook_app_id'                        => __('Facebook App ID', 'ameliabooking'),
            'facebook_app_secret'                    => __('Facebook App Secret', 'ameliabooking'),
            'general'                                => __('General', 'ameliabooking'),
            'general_settings'                       => __('General Settings', 'ameliabooking'),
            'general_labels_warning'                 => __('Please note that these labels are applied only to the old booking forms and WooCommerce payments. To set labels for the 2.0 Amelia Booking forms kindly visit the', 'ameliabooking'),
            'general_settings_description'           => __('Use these settings to define plugin general settings and default settings for your services and appointments', 'ameliabooking'),
            'gMap_api_key'                           => __('Google Map API Key', 'ameliabooking'),
            'gMap_api_key_tooltip'                   => __('Add Google Map API Key to show Google static map on<br/>"Locations" page.', 'ameliabooking'),
            'google_client_id'                       => __('Client ID', 'ameliabooking'),
            'google_client_secret'                   => __('Client Secret', 'ameliabooking'),
            'outlook_client_id'                      => __('Application (client) ID', 'ameliabooking'),
            'outlook_client_secret'                  => __('Client Secret', 'ameliabooking'),
            'google_redirect_uri'                    => __('Redirect URI', 'ameliabooking'),
            'outlook_redirect_uri'                   => __('Redirect URI', 'ameliabooking'),
            'apple_client_id'                        => __('iCloud Email Address', 'ameliabooking'),
            'icloud_app_specific_password'           => __('iCloud App-specific Password', 'ameliabooking'),
            'apple_redirect_uri'                     => __('Redirect URI', 'ameliabooking'),
            'zoom_api_key'                           => __('Client Key', 'ameliabooking'),
            'zoom_api_secret'                        => __('Client Secret', 'ameliabooking'),
            'zoom_jwt_warning'                       => __('The JWT app type is deprecated. We recommend that you create Server-to-Server OAuth', 'ameliabooking'),
            'zoom_s2s'                               => __('Enable Server-to-Server OAuth', 'ameliabooking'),
            'zoom_account_id'                        => __('Account ID', 'ameliabooking'),
            'zoom_client_id'                         => __('Client ID', 'ameliabooking'),
            'zoom_client_secret'                     => __('Client Secret', 'ameliabooking'),
            'lesson_space_api_key'                   => __('Lesson Space API Key', 'ameliabooking'),
            'limit_app_per_customer'                 => __('Limit appointments per customer', 'ameliabooking'),
            'limit_package_per_customer'             => __('Limit package purchases per customer', 'ameliabooking'),
            'limit_events_per_customer'              => __('Limit events per customer', 'ameliabooking'),
            'limit_app_per_customer_tt'              => __('The limit is checked by customer email', 'ameliabooking'),
            'limit_package_per_customer_tt'          => __('The limit is checked by customer email', 'ameliabooking'),
            'limit_events_per_customer_tt'           => __('The limit is checked by customer email', 'ameliabooking'),
            'log_in'                                 => __('Log In', 'ameliabooking'),
            'log_out'                                => __('Log Out', 'ameliabooking'),
            'integrations_settings'                  => __('Integrations', 'ameliabooking'),
            'integrations_settings_description'      => __("Manage Google Calendar Integration, Outlook Calendar Integration, Zoom Integration and Web Hooks", 'ameliabooking'),
            'invoice_format'                         => __('Invoice Format', 'ameliabooking'),
            'iplocate_api_key'                       => __('IPLocate Api Key', 'ameliabooking'),
            'iplocate_api_key_tooltip'               => __('Please sign up for an API key at iplocate.io/signup for 1000 free API requests/day.<br/> The limit for access without an API key has been reduced to 50 requests/day.', 'ameliabooking'),
            'h1'                                     => __('1h', 'ameliabooking'),
            'h10'                                    => __('10h', 'ameliabooking'),
            'h11'                                    => __('11h', 'ameliabooking'),
            'h12'                                    => __('12h', 'ameliabooking'),
            'h1min30'                                => __('1h 30min', 'ameliabooking'),
            'h2'                                     => __('2h', 'ameliabooking'),
            'h3'                                     => __('3h', 'ameliabooking'),
            'h4'                                     => __('4h', 'ameliabooking'),
            'h6'                                     => __('6h', 'ameliabooking'),
            'h8'                                     => __('8h', 'ameliabooking'),
            'h9'                                     => __('9h', 'ameliabooking'),
            'identify_country_code'                  => __('Identify country code by user\'s IP address', 'ameliabooking'),
            'insert_pending_appointments'            => __('Insert Pending Appointments', 'ameliabooking'),
            'pending_appointments_meetings'          => __('Create Meetings For Pending Appointments', 'ameliabooking'),
            'inspect_customer_info'                  => __('Check customer\'s name for existing email/phone when booking', 'ameliabooking'),
            'inspect_customer_info_tooltip'          => __('Enable this option to ensure that customers using an existing email or phone number maintain consistent first and last names.', 'ameliabooking'),
            'label_employee'                         => __('Employee', 'ameliabooking'),
            'label_employees'                        => __('Employees', 'ameliabooking'),
            'label_service'                          => __('Service', 'ameliabooking'),
            'label_services'                         => __('Services', 'ameliabooking'),
            'labels'                                 => __('Labels', 'ameliabooking'),
            'labels_settings'                        => __('Labels Settings', 'ameliabooking'),
            'labels_settings_description'            => __('Use these settings to change labels on frontend pages', 'ameliabooking'),
            'mail_service'                           => __('Mail Service', 'ameliabooking'),
            'mailgun'                                => __('Mailgun', 'ameliabooking'),
            'manage_languages'                       => __('Manage languages', 'ameliabooking'),
            'manage_languages_tooltip'               => __('Here you can define languages that you want to have in the plugin<br>for translating dynamic strings (names, descriptions, notifications).', 'ameliabooking'),
            'marketing_tools'                        => __('Marketing Tools', 'ameliabooking'),
            'min1'                                   => __('1min', 'ameliabooking'),
            'min10'                                  => __('10min', 'ameliabooking'),
            'min12'                                  => __('12min', 'ameliabooking'),
            'min15'                                  => __('15min', 'ameliabooking'),
            'min2'                                   => __('2min', 'ameliabooking'),
            'min20'                                  => __('20min', 'ameliabooking'),
            'min30'                                  => __('30min', 'ameliabooking'),
            'min45'                                  => __('45min', 'ameliabooking'),
            'min5'                                   => __('5min', 'ameliabooking'),
            'minimum_time_before_booking'            => __('Minimum time required before booking', 'ameliabooking'),
            'minimum_time_before_booking_tooltip'    => __('Set the time before the appointment when customers<br/>will not be able to book the appointment.', 'ameliabooking'),
            'minimum_time_before_canceling'          => __('Minimum time required before canceling', 'ameliabooking'),
            'minimum_time_before_canceling_tooltip'  => __('Set the time before the appointment when customers<br/>will not be able to cancel the appointment.', 'ameliabooking'),
            'minimum_time_before_rescheduling'       => __('Minimum time required before rescheduling', 'ameliabooking'),
            'minimum_time_before_rescheduling_tooltip'  => __('Set the time before the appointment when customers<br/>will not be able to reschedule the appointment.', 'ameliabooking'),
            'notifications_settings'                 => __('Notification Settings', 'ameliabooking'),
            'notifications_settings_description'     => __('Use these settings to set your mail settings which will be used to notify your customers and employees', 'ameliabooking'),
            'notify_customers_default'               => __('Notify the customer(s) by default', 'ameliabooking'),
            'number_of_events_returned'              => __('Maximum Number Of Events Returned', 'ameliabooking'),
            'outdated'                               => __('Outdated', 'ameliabooking'),
            'outlook_mail_api'                       => __('Outlook Mailer', 'ameliabooking'),
            'payment_links_enable'                   => __('Allow payment via Payment Link', 'ameliabooking'),
            'payment_links_enable_tooltip'           => __('If this option is enabled customers will be able to pay via email notifications or through their Customer panel.', 'ameliabooking'),
            'payments'                               => __('Payments', 'ameliabooking'),
            'payments_settings'                      => __('Payments Settings', 'ameliabooking'),
            'payments_settings_description'          => __('Use these settings to set price format, payment method and coupons that will be used in all bookings', 'ameliabooking'),
            'period_available_for_booking'           => __('Period available for booking in advance', 'ameliabooking'),
            'period_available_for_booking_tooltip'   => __('Set how far customers can book.', 'ameliabooking'),
            'php_mail'                               => __('PHP Mail', 'ameliabooking'),
            'price_number_of_decimals'               => __('Price Number Of Decimals', 'ameliabooking'),
            'price_separator'                        => __('Price Separator', 'ameliabooking'),
            'price_symbol_position'                  => __('Price Symbol Position', 'ameliabooking'),
            'purchase_code'                          => __('Purchase code', 'ameliabooking'),
            'provider_details_settings'              => __('Provider Details', 'ameliabooking'),
            'provider_details_settings_description'  => __('Use this setting to configure provider details', 'ameliabooking'),
            'recaptcha_enabled'                      => __('Enable Google reCAPTCHA', 'ameliabooking'),
            'recaptcha_enabled_tooltip'              => __('Enable this option if you want to add Google reCAPTCHA on the front-end booking forms', 'ameliabooking'),
            'redirect_urls'                          => __('Redirect URLs', 'ameliabooking'),
            'redirect_url_after_appointment'         => __('Redirect URL After Booking', 'ameliabooking'),
            'redirect_url_after_appointment_tooltip' => __('Customer will be redirected to this URL once he schedules the appointment.', 'ameliabooking'),
            'remove_google_busy_slots'               => __('Remove Google Calendar Busy Slots', 'ameliabooking'),
            'remove_outlook_busy_slots'              => __('Remove Outlook Calendar Busy Slots', 'ameliabooking'),
            'remove_apple_busy_slots'                => __('Remove Apple Calendar Busy Slots', 'ameliabooking'),
            'include_buffer_time_google'             => __('Include Buffer time in Google events', 'ameliabooking'),
            'include_buffer_time_outlook'            => __('Include Buffer time in Outlook events', 'ameliabooking'),
            'include_buffer_time_apple'              => __('Include Buffer time in Apple events', 'ameliabooking'),
            'reject_appointment_success_url'         => __('Redirect URL for Successfully Rejected Booking', 'ameliabooking'),
            'reject_appointment_error_url'           => __('Redirect URL for Unsuccessfully Rejected Booking', 'ameliabooking'),
            'reply_to'                               => __('Reply-to Email', 'ameliabooking'),
            'require_cabinet_password'               => __('Require password for login', 'ameliabooking'),
            'required_email_field'                   => __('Set email as a mandatory field', 'ameliabooking'),
            'required_phone_number_field'            => __('Set a phone number as a mandatory field', 'ameliabooking'),
            'required_field_old_tooltip'             => __('This option does not apply to new forms,<br/> for that please check the customize page.', 'ameliabooking'),
            'roles_settings'                         => __('Roles Settings', 'ameliabooking'),
            'roles_settings_description'             => __('Use these settings to define settings that will be applied for the specific Amelia roles', 'ameliabooking'),
            'send_event_invitation_email'            => __('Send Event Invitation Email', 'ameliabooking'),
            'send_invoice_by_default'                => __('Send invoice to customer by default', 'ameliabooking'),
            'send_invoice_by_default_description'    => __('Enable this option to make sure that the invoice will be sent to the customer after booking.', 'ameliabooking'),
            'send_ics_attachment_approved'           => __('Send ics file for Approved bookings', 'ameliabooking'),
            'send_ics_attachment_pending'            => __('Send ics file for Pending bookings', 'ameliabooking'),
            'send_ics_attachment_approved_tooltip'   => __('Enable this option if you want to send ics file in email after approved bookings.', 'ameliabooking'),
            'send_ics_attachment_pending_tooltip'    => __('Enable this option if you want to send ics file in email after pending bookings.', 'ameliabooking'),
            'send_sms_balance_low_email'             => __('Remind me when my SMS balance is low', 'ameliabooking'),
            'send_sms_balance_low_email_tooltip'     => __('Enable this option to receive a reminder email when your SMS balance reaches set minimum', 'ameliabooking'),
            'send_sms_balance_low_minimum'           => __('Credit minimum to send reminder', 'ameliabooking'),
            'send_sms_balance_low_to_email'          => __('Send to e-mail', 'ameliabooking'),
            'sender_email'                           => __('Sender Email', 'ameliabooking'),
            'sender_email_warning'                   => __('Please enter sender email', 'ameliabooking'),
            'sender_name'                            => __('Sender Name', 'ameliabooking'),
            'sender_name_warning'                    => __('Please enter sender name', 'ameliabooking'),
            'service_duration_as_slot'               => __('Use service duration for booking a time slot', 'ameliabooking'),
            'service_duration_as_slot_tooltip'       => __('Enable this option if you want to make time slot step<br/>the same as service duration in the booking process', 'ameliabooking'),
            'set_ics_description'                    => __('Set Ics File Description', 'ameliabooking'),
            'set_metaData_and_description'           => __('Set MetaData and Description', 'ameliabooking'),
            'settings'                               => __('Settings', 'ameliabooking'),
            'show_attendees'                         => __('Allow customers to see other attendees', 'ameliabooking'),
            'show_client_time_zone'                  => __('Show booking slots in client time zone', 'ameliabooking'),
            'show_client_time_zone_tooltip'          => __('Enable this option if you want to show booking slots<br/>in client time zone.', 'ameliabooking'),
            'smtp'                                   => __('SMTP', 'ameliabooking'),
            'space_comma'                            => __('Space-Comma', 'ameliabooking'),
            'space_dot'                              => __('Space-Dot', 'ameliabooking'),
            'stash_entities'                         => __('Load Entities on page load', 'ameliabooking'),
            'stash_entities_tooltip'                 => __('Enable this option if you want to avoid AJAX calls<br>for fetching entities (services, employees, locations, packages, tags)', 'ameliabooking'),
            'square'                                 => __('Square', 'ameliabooking'),
            'square_disconnected'                    => __('Square account successfully disconnected', 'ameliabooking'),
            'square_currency_error'                  => __('The currency in Amelia does not match the currency of your chosen Square location', 'ameliabooking'),
            'square_default_location'                => __('Default Square location', 'ameliabooking'),
            'square_login_error'                     => __('Please log in to Square', 'ameliabooking'),
            'square_login_failed'                    => __('There has been an error logging in to Square. Please try again.', 'ameliabooking'),
            'square_location_error'                  => __('Select your Square Location', 'ameliabooking'),
            'square_location_info'                   => __('Locations must be active and have card processing enabled', 'ameliabooking'),
            'square_php_version_error'               => __('To use Square, you must have PHP version 7.4 or higher', 'ameliabooking'),
            'square_service'                         => __('Square Service', 'ameliabooking'),
            'tax_enable'                             => __('Enable Taxes', 'ameliabooking'),
            'outlook_ssl_warning'                    => __('SSL (HTTPS) is not enabled. You will not be able to use Outlook Calendar integration until SSL is enabled.', 'ameliabooking'),
            'update_for_all'                         => __('Update for all', 'ameliabooking'),
            'custom_fields_upload_path'              => __('Attachment upload path', 'ameliabooking'),
            'custom_fields_upload_path_tooltip'      => __('If you leave this field empty, all attachments will be uploaded into the Wordpress uploads folder.', 'ameliabooking'),
            'view_activation_settings'               => __('View Activation Settings', 'ameliabooking'),
            'vat_number'                             => __('VAT number', 'ameliabooking'),
            'view_appointments_and_events_settings'  => __('View Appointments and Events Settings', 'ameliabooking'),
            'view_company_settings'                  => __('View Company Settings', 'ameliabooking'),
            'view_general_settings'                  => __('View General Settings', 'ameliabooking'),
            'view_integrations_settings'             => __('View Integrations Settings', 'ameliabooking'),
            'view_labels_settings'                   => __('View Labels Settings', 'ameliabooking'),
            'view_notifications_settings'            => __('View Notifications Settings', 'ameliabooking'),
            'view_payments_settings'                 => __('View Payments Settings', 'ameliabooking'),
            'view_provider_details_settings'         => __('Provider Details', 'ameliabooking'),
            'view_roles_settings_description'        => __('View Roles Settings', 'ameliabooking'),
            'view_api_keys_settings'                 => __('View API keys Settings', 'ameliabooking'),
            'website'                                => __('Website', 'ameliabooking'),
            'web_hooks'                              => __('Web Hooks', 'ameliabooking'),
            'wp_mail'                                => __('WP Mail', 'ameliabooking'),
            'hide_currency_symbol_frontend'          => __('Hide Currency Symbol on the booking form', 'ameliabooking'),
            'custom_currency_symbol'                 => __('Custom Currency Symbol', 'ameliabooking'),
            'your_api_key'                           => __('Your API key', 'ameliabooking'),
            'admin_time_slot_service_duration'       => __('Booking Time Slots will depend on the service duration', 'ameliabooking'),
            'admin_time_slot_service_duration_tt'    => __('When this option is deactivated, the booking will be<br/>determined based on the Default Time Slot Step', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the email notifications strings
     *
     * @return array
     */
    public static function getNotificationsStrings()
    {
        return [
            'amelia_sms'                             => __('Amelia SMS', 'ameliabooking'),
            'balance_colon'                          => __('Balance:', 'ameliabooking'),
            'balance_recharged'                      => __('Your balance has been recharged', 'ameliabooking'),
            'carrier'                                => __('Carrier:', 'ameliabooking'),
            'change_alpha_sender_id'                 => __('Change Alpha Sender ID', 'ameliabooking'),
            'change_password'                        => __('Change Password', 'ameliabooking'),
            'cost_colon'                             => __('Cost:', 'ameliabooking'),
            'create_notification'                    => __('Create New Notification', 'ameliabooking'),
            'current_password_colon'                 => __('Current Password:', 'ameliabooking'),
            'current_password_requred'               => __('Please enter current password', 'ameliabooking'),
            'customer_appointment_approved'          => __('Appointment Approved', 'ameliabooking'),
            'customer_appointment_canceled'          => __('Appointment Canceled', 'ameliabooking'),
            'customer_appointment_follow_up'         => __('Appointment Follow Up', 'ameliabooking'),
            'customer_appointment_next_day_reminder' => __('Appointment Next Day Reminder', 'ameliabooking'),
            'customer_appointment_pending'           => __('Appointment Pending', 'ameliabooking'),
            'customer_appointment_rejected'          => __('Appointment Rejected', 'ameliabooking'),
            'customer_appointment_rescheduled'       => __('Appointment Rescheduled', 'ameliabooking'),
            'customer_account_recovery'              => __('Customer Panel Access', 'ameliabooking'),
            'customer_appointment_updated'           => __('Appointment Details Changed', 'ameliabooking'),
            'customer_birthday_greeting'             => __('Birthday Greeting', 'ameliabooking'),
            'customer_event_approved'                => __('Event Booked', 'ameliabooking'),
            'customer_event_canceled'                => __('Event Canceled By Attendee', 'ameliabooking'),
            'customer_event_follow_up'               => __('Event Follow Up', 'ameliabooking'),
            'customer_event_next_day_reminder'       => __('Event Next Day Reminder', 'ameliabooking'),
            'customer_event_rejected'                => __('Event Canceled By Admin', 'ameliabooking'),
            'customer_event_rescheduled'             => __('Event Rescheduled', 'ameliabooking'),
            'customer_event_updated'                 => __('Event Details Changed', 'ameliabooking'),
            'customer_event_qr_code'                 => __('Event E-Ticket', 'ameliabooking'),
            'customer_other_notifications'           => __('Other', 'ameliabooking'),
            'customer_event_waiting'                 => __('Event Waiting List', 'ameliabooking'),
            'provider_other_notifications'           => __('Other', 'ameliabooking'),
            'customer_cart'                          => __('Cart Purchase', 'ameliabooking'),
            'customer_invoice'                       => __('Booking Invoice', 'ameliabooking'),
            'customer_package_canceled'              => __('Package Canceled', 'ameliabooking'),
            'customer_package_purchased'             => __('Package Purchased', 'ameliabooking'),
            'customize_sms'                          => __('Customize SMS', 'ameliabooking'),
            'date_colon'                             => __('Date:', 'ameliabooking'),
            'dont_have_an_account'                   => __('Don\'t have an account?', 'ameliabooking'),
            'email_colon'                            => __('Email:', 'ameliabooking'),
            'email_notifications'                    => __('Email Notifications', 'ameliabooking'),
            'enter_password_warning'                 => __('Please enter password', 'ameliabooking'),
            'enter_recipient_phone_warning'          => __('Please enter recipient phone', 'ameliabooking'),
            'forgot_password'                        => __('Forgot Password?', 'ameliabooking'),
            'incorrect_email'                        => __('You have entered an incorrect email', 'ameliabooking'),
            'incorrect_password'                     => __('You have entered an incorrect password', 'ameliabooking'),
            'insert_email_placeholders'              => __('Insert email placeholders', 'ameliabooking'),
            'insert_email_placeholders_tooltip'      => __('Choose one of the placeholders from the lists below, click on it to copy and then paste into the template.', 'ameliabooking'),
            'logout'                                 => __('Logout', 'ameliabooking'),
            'message_colon'                          => __('Message:', 'ameliabooking'),
            'messages_lower'                         => __('messages', 'ameliabooking'),
            'new_password_colon'                     => __('New Password:', 'ameliabooking'),
            'new_password_requred'                   => __('Please enter new password', 'ameliabooking'),
            'notification_saved'                     => __('Notification has been saved', 'ameliabooking'),
            'notification_template'                  => __('Notification Template', 'ameliabooking'),
            'notifications'                          => __('Notifications', 'ameliabooking'),
            'password_colon'                         => __('Password:', 'ameliabooking'),
            'payment_history'                        => __('Payment History', 'ameliabooking'),
            'ph_appointment_date'                    => __('Date of the appointment', 'ameliabooking'),
            'ph_appointment_date_time'               => __('Date & Time of the appointment', 'ameliabooking'),
            'ph_appointment_duration'                => __('Duration of the appointment', 'ameliabooking'),
            'ph_appointment_end_time'                => __('End time of the appointment', 'ameliabooking'),
            'ph_appointment_id'                      => __('Id of the appointment', 'ameliabooking'),
            'ph_payment_due_amount'                  => __('Payment due amount', 'ameliabooking'),
            'ph_appointment_notes'                   => __('Appointment notes', 'ameliabooking'),
            'ph_appointment_price'                   => __('Appointment price', 'ameliabooking'),
            'ph_payment_type'                        => __('Payment type', 'ameliabooking'),
            'ph_appointment_status'                  => __('Status of the appointment', 'ameliabooking'),
            'ph_appointment_start_time'              => __('Start time of the appointment', 'ameliabooking'),
            'ph_attendee_code'                       => __('Attendee code', 'ameliabooking'),
            'ph_booked_customer'                     => __('Booked Customer (full name, email, phone)', 'ameliabooking'),
            'ph_booking_number_of_persons'           => __('Number of people', 'ameliabooking'),
            'ph_category_id'                         => __('Category ID', 'ameliabooking'),
            'ph_category_name'                       => __('Category name', 'ameliabooking'),
            'ph_company_address'                     => __('Company address', 'ameliabooking'),
            'ph_company_name'                        => __('Company name', 'ameliabooking'),
            'ph_company_phone'                       => __('Company phone', 'ameliabooking'),
            'ph_company_website'                     => __('Company website', 'ameliabooking'),
            'ph_company_email'                       => __('Company email', 'ameliabooking'),
            'ph_company_vat_number'                  => __('Company VAT number', 'ameliabooking'),
            'ph_customer_email'                      => __('Customer email', 'ameliabooking'),
            'ph_customer_first_name'                 => __('Customer first name', 'ameliabooking'),
            'ph_customer_full_name'                  => __('Customer full name', 'ameliabooking'),
            'ph_customer_last_name'                  => __('Customer last name', 'ameliabooking'),
            'ph_customer_note'                       => __('Customer note', 'ameliabooking'),
            'ph_customer_phone'                      => __('Customer phone', 'ameliabooking'),
            'ph_employee_description'                => __('Employee description', 'ameliabooking'),
            'ph_employee_id'                         => __('Employee ID', 'ameliabooking'),
            'ph_employee_email'                      => __('Employee email', 'ameliabooking'),
            'ph_employee_first_name'                 => __('Employee first name', 'ameliabooking'),
            'ph_employee_full_name'                  => __('Employee full name', 'ameliabooking'),
            'ph_employee_last_name'                  => __('Employee last name', 'ameliabooking'),
            'ph_employee_name_email_phone'           => __('Employee name, email & phone', 'ameliabooking'),
            'ph_employee_note'                       => __('Employee note', 'ameliabooking'),
            'ph_employee_phone'                      => __('Employee phone', 'ameliabooking'),
            'ph_event_description'                   => __('Event description', 'ameliabooking'),
            'ph_event_location'                      => __('Event Location', 'ameliabooking'),
            'ph_event_end_date'                      => __('End date of the event', 'ameliabooking'),
            'ph_event_end_date_time'                 => __('End date & time of the event', 'ameliabooking'),
            'ph_event_end_time'                      => __('End time of the event', 'ameliabooking'),
            'ph_event_id'                            => __('Event ID', 'ameliabooking'),
            'ph_event_name'                          => __('Event name', 'ameliabooking'),
            'ph_event_period_date'                   => __('Date period of the event', 'ameliabooking'),
            'ph_event_period_date_time'              => __('Date & Time period of the event', 'ameliabooking'),
            'ph_event_price'                         => __('Event price', 'ameliabooking'),
            'ph_booking_price'                       => __('Booking price', 'ameliabooking'),
            'ph_event_start_date'                    => __('Start date of the event', 'ameliabooking'),
            'ph_event_start_date_time'               => __('Start date & time of the event', 'ameliabooking'),
            'ph_event_start_time'                    => __('Start time of the event', 'ameliabooking'),
            'ph_group_event_details'                 => __('Group event details', 'ameliabooking'),
            'ph_recurring_tooltip'                   => __('Set what details you want to send to your customers/employees about their recurring appointments.', 'ameliabooking'),
            'ph_service_description'                 => __('Service description', 'ameliabooking'),
            'ph_service_duration'                    => __('Service duration', 'ameliabooking'),
            'ph_service_id'                          => __('Service ID', 'ameliabooking'),
            'ph_service_name'                        => __('Service name', 'ameliabooking'),
            'ph_service_price'                       => __('Service price', 'ameliabooking'),
            'ph_time_zone'                           => __('Time Zone', 'ameliabooking'),
            'ph_number_of_persons'                   => __('Number of persons', 'ameliabooking'),
            'phone_colon'                            => __('Phone:', 'ameliabooking'),
            'sms_warning'                            => __('Effective September 30th, SMS providers will implement charges for failed message deliveries. To help minimize the occurrence of failed messages, please adhere to the following guidelines: <br>
                                                               <ol style="margin-left: 16px">
                                                                <li>For countries where Alphanumeric Sender IDs are not permitted, the Alphanumeric Sender ID will be replaced with the phone number. A complete list of affected countries is available <a href="https://wpamelia.com/sms-notifications/">here</a>.</li>
                                                                <li>Update the label of the “Phone Number” field through Amelia’s Customize menu to “Mobile phone number” to ensure users enter the correct format and to avoid failures caused by sending SMS to landline numbers.</li>
                                                                <li>Use HTTPS links instead of HTTP, as HTTP links may be flagged as insecure, leading to potential delivery issues.</li>
                                                               </ol>
                                                               Amelia forwards messages to external SMS providers, who charge for all delivery attempts, successful or failed, so following the provided guidelines can help minimize costs.'),
            'provider_cart'                          => __('Cart Purchase', 'ameliabooking'),
            'companyPlaceholders'                    => __('Company', 'ameliabooking'),
            'customerPlaceholders'                   => __('Customer', 'ameliabooking'),
            'paymentPlaceholders'                    => __('Payment', 'ameliabooking'),
            'employeePlaceholders'                   => __('Employee', 'ameliabooking'),
            'categoryPlaceholders'                   => __('Category', 'ameliabooking'),
            'locationPlaceholders'                   => __('Location', 'ameliabooking'),
            'appointmentPlaceholders'                => __('Appointment', 'ameliabooking'),
            'eventPlaceholders'                      => __('Event', 'ameliabooking'),
            'extrasPlaceholders'                     => __('Extra', 'ameliabooking'),
            'placeholder_copied'                     => __('Placeholder Copied', 'ameliabooking'),
            'price'                                  => __('Price', 'ameliabooking'),
            'pricing'                                => __('Pricing', 'ameliabooking'),
            'provider_appointment_approved'          => __('Appointment Approved', 'ameliabooking'),
            'provider_appointment_canceled'          => __('Appointment Canceled', 'ameliabooking'),
            'provider_appointment_next_day_reminder' => __('Appointment Next Day Reminder', 'ameliabooking'),
            'provider_appointment_updated'           => __('Appointment Details Changed', 'ameliabooking'),
            'provider_package_canceled'              => __('Package Canceled', 'ameliabooking'),
            'provider_package_purchased'             => __('Package Purchased', 'ameliabooking'),
            'provider_panel_access'                  => __('Employee Panel Access', 'ameliabooking'),
            'provider_panel_recovery'                => __('Employee Panel Recovery', 'ameliabooking'),
            'provider_appointment_pending'           => __('Appointment Pending', 'ameliabooking'),
            'provider_appointment_rejected'          => __('Appointment Rejected', 'ameliabooking'),
            'provider_appointment_rescheduled'       => __('Appointment Rescheduled', 'ameliabooking'),
            'provider_event_approved'                => __('Event Booked', 'ameliabooking'),
            'provider_event_canceled'                => __('Event Canceled By Attendee', 'ameliabooking'),
            'provider_event_next_day_reminder'       => __('Event Next Day Reminder', 'ameliabooking'),
            'provider_event_rejected'                => __('Event Canceled By Admin', 'ameliabooking'),
            'provider_event_rescheduled'             => __('Event Rescheduled', 'ameliabooking'),
            'provider_event_updated'                 => __('Event Details Changed', 'ameliabooking'),
            'provider_event_waiting'                 => __('Event Waiting List', 'ameliabooking'),
            'queued'                                 => __('Queued', 'ameliabooking'),
            're_type_requred'                        => __('Please enter new password again', 'ameliabooking'),
            'recharge'                               => __('Recharge', 'ameliabooking'),
            'recharge_balance'                       => __('Recharge Balance', 'ameliabooking'),
            'recipient_email'                        => __('Recipient Email', 'ameliabooking'),
            'refresh'                                => __('Refresh', 'ameliabooking'),
            'requires_scheduling_setup'              => __('Requires Scheduling Setup', 'ameliabooking'),
            'retype_new_password_colon'              => __('Re-type New Password:', 'ameliabooking'),
            'security'                               => __('Security', 'ameliabooking'),
            'segments_colon'                         => __('Segments:', 'ameliabooking'),
            'send'                                   => __('Send', 'ameliabooking'),
            'send_recovery_email'                    => __('Send Recovery Email', 'ameliabooking'),
            'send_test_email'                        => __('Send Test Email', 'ameliabooking'),
            'send_test_sms'                          => __('Send Test SMS', 'ameliabooking'),
            'sender_id_colon'                        => __('Alpha Sender ID:', 'ameliabooking'),
            'sign_in'                                => __('Sign In', 'ameliabooking'),
            'sign_up'                                => __('Sign Up', 'ameliabooking'),
            'sms_history'                            => __('SMS History', 'ameliabooking'),
            'sms_notifications'                      => __('SMS Notifications', 'ameliabooking'),
            'sms_vat_apply'                          => __('If you are from a country where VAT or GST applies, a VAT/GST charge will be added to the transaction.', 'ameliabooking'),
            'status_colon'                           => __('Status:', 'ameliabooking'),
            'subject'                                => __('Subject', 'ameliabooking'),
            'test_email_error'                       => __('Email has not been sent', 'ameliabooking'),
            'test_email_success'                     => __('Email has been sent', 'ameliabooking'),
            'test_email_warning'                     => __('To be able to send test email please configure "Sender Email" in Notification Settings.', 'ameliabooking'),
            'test_sms_warning'                       => __('To be able to send test SMS please recharge your balance.', 'ameliabooking'),
            'text_colon'                             => __('Text:', 'ameliabooking'),
            'time_colon'                             => __('Time:', 'ameliabooking'),
            'to_customer'                            => __('To Customer', 'ameliabooking'),
            'to_employee'                            => __('To Employee', 'ameliabooking'),
            'user_colon'                             => __('User:', 'ameliabooking'),
            'user_profile'                           => __('User Profile', 'ameliabooking'),
            'view_pricing_for'                       => __('View pricing for:', 'ameliabooking'),
            'view_profile'                           => __('View Profile', 'ameliabooking'),
            'whatsapp_access_token'                  => __('Permanent access token', 'ameliabooking'),
            'whatsapp_auto_reply_enable'             => __('Enable Auto-reply message', 'ameliabooking'),
            'whatsapp_auto_reply_notice'             => __('Messages sent through WhatsApp are without a reply option, so we advise setting the “Auto-Reply” message', 'ameliabooking'),
            'whatsapp_auto_reply_token'              => __('WhatsApp Webhook Verify Token', 'ameliabooking'),
            'whatsapp_auto_reply_msg'                => __('WhatsApp Auto-reply message', 'ameliabooking'),
            'whatsapp_business_id'                   => __('WhatsApp Business Account ID', 'ameliabooking'),
            'whatsapp_default_language'              => __('Default language', 'ameliabooking'),
            'whatsapp_notifications'                 => __('WhatsApp Notifications', 'ameliabooking'),
            'whatsapp_enabled'                       => __('Enable WhatsApp Notifications', 'ameliabooking'),
            'whatsapp_phone_id'                      => __('Phone number ID', 'ameliabooking'),
            'whatsapp_settings'                      => __('Settings', 'ameliabooking'),
            'whatsapp_webhook_url_callback'          => __('WhatsApp Webhook Callback URL', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the common strings
     *
     * @return array
     */
    public static function getDashboardStrings()
    {
        return [
            'appointments_count'            => __('# of appointments', 'ameliabooking'),
            'appointments_revenue'          => __('Sum of payments', 'ameliabooking'),
            'appointments_hours'            => __('# of Hours in appointment', 'ameliabooking'),
            'appointments_load'             => __('% of load', 'ameliabooking'),
            'approved_appointments'         => __('Approved Appointments', 'ameliabooking'),
            'approved_appointments_tooltip' => __('Indicates the number of approved appointments<br/>for a chosen date range.', 'ameliabooking'),
            'conversions'                   => __('Interests / Conversions', 'ameliabooking'),
            'conversions_tooltip'           => __('Shows the number of views for the employee/service/location<br/>vs. the number of times they were booked during<br/>the selected date range.', 'ameliabooking'),
            'customers_tooltip'             => __('Indicates the number of new and returning customers<br/>for the selected date range.', 'ameliabooking'),
            'dashboard'                     => __('Dashboard', 'ameliabooking'),
            'grab_yours'                    => __('Grab Yours', 'ameliabooking'),
            'new'                           => __('New', 'ameliabooking'),
            'no_upcoming_appointments'      => __('You don\'t have any upcoming appointments yet', 'ameliabooking'),
            'not_show'                      => __('Don\'t show again', 'ameliabooking'),
            'pending_appointments'          => __('Pending Appointments', 'ameliabooking'),
            'percentage_of_load'            => __('Percentage of Load', 'ameliabooking'),
            'percentage_of_load_tooltip'    => __('Indicates the percentage of occupied time against available time for appointments<br/>in the chosen date range.', 'ameliabooking'),
            'returning'                     => __('Returning', 'ameliabooking'),
            'revenue'                       => __('Revenue', 'ameliabooking'),
            'revenue_tooltip'               => __('Shows the total income for paid appointments<br/>in the chosen date range.', 'ameliabooking'),
            'time'                          => __('Time', 'ameliabooking'),
            'views'                         => __('Views', 'ameliabooking'),
            'hello_message_part0'           => __('Hello', 'ameliabooking'),
            'hello_message_part1'           => __('You have', 'ameliabooking'),
            'hello_message_part2'           => __('and', 'ameliabooking'),
            'hello_message_part3'           => __('for today', 'ameliabooking'),
            'upcoming_appointments'         => __('Upcoming appointments', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the schedule modal
     *
     * @return array
     */
    public static function getScheduleStrings()
    {
        return [
            'add_day_off'                         => __('Add Day Off', 'ameliabooking'),
            'add_special_day'                     => __('Add Special Day', 'ameliabooking'),
            'apply_to_all_days'                   => __('Apply to All Days', 'ameliabooking'),
            'breaks'                              => __('Breaks', 'ameliabooking'),
            'days_off_add'                        => __('Add Day Off', 'ameliabooking'),
            'day_off_name'                        => __('Day Off name', 'ameliabooking'),
            'days_off_repeat_yearly'              => __('Repeat Yearly', 'ameliabooking'),
            'days_off'                            => __('Days Off', 'ameliabooking'),
            'once_off'                            => __('Once Off', 'ameliabooking'),
            'repeat_every_year'                   => __('Repeat Every Year', 'ameliabooking'),
            'save_special_day'                    => __('Save Special Day', 'ameliabooking'),
            'special_day_date_warning'            => __('Please enter date', 'ameliabooking'),
            'special_day_end_time_warning'        => __('Please enter end time', 'ameliabooking'),
            'special_day_start_time_warning'      => __('Please enter start time', 'ameliabooking'),
            'work_hours'                          => __('Work Hours', 'ameliabooking'),
            'break_hours'                         => __('Break Hours', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the entities modal
     *
     * @return array
     */
    public static function getEntityFormStrings()
    {
        return [
            'visibility_hide' => __('Hide', 'ameliabooking'),
            'visibility_show' => __('Show', 'ameliabooking'),
            'block'           => __('Block', 'ameliabooking'),
            'unblock'         => __('Unblock', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the location page
     *
     * @return array
     */
    public static function getLocationStrings()
    {
        return [
            'add_location'                   => __('Add Location', 'ameliabooking'),
            'locations_search_placeholder'   => __('Search Locations...', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the service page
     *
     * @return array
     */
    public static function getServiceStrings()
    {
        return [
            'add_category'                       => __('Add Category', 'ameliabooking'),
            'add_extra'                          => __('Add Extra', 'ameliabooking'),
            'add_image'                          => __('Add Image', 'ameliabooking'),
            'add_package'                        => __('Add Package', 'ameliabooking'),
            'add_service'                        => __('Add Service', 'ameliabooking'),
            'add_resource'                       => __('Add Resource', 'ameliabooking'),
            'categories'                         => __('Categories', 'ameliabooking'),
            'categories_positions_saved'         => __('Categories positions has been saved', 'ameliabooking'),
            'category_deleted'                   => __('Category has been deleted', 'ameliabooking'),
            'category_duplicated'                => __('Category has been duplicated', 'ameliabooking'),
            'category_saved'                     => __('Category has been saved', 'ameliabooking'),
            'click_add_category'                 => __('Start by clicking the Add Category button', 'ameliabooking'),
            'click_add_package'                  => __('Start by clicking the Add Package button', 'ameliabooking'),
            'click_add_resource'                 => __('Start by clicking the Add Resource button', 'ameliabooking'),
            'click_add_service'                  => __('Start by clicking the Add Service button', 'ameliabooking'),
            'confirm_delete_service'             => __('Are you sure you want to delete this service?', 'ameliabooking'),
            'confirm_duplicate_service'          => __('Are you sure you want to duplicate this service?', 'ameliabooking'),
            'confirm_global_change_service'      => __('You will change a setting which is also set for each employee separately. Do you want to update it for all employees?', 'ameliabooking'),
            'confirm_hide_service'               => __('Are you sure you want to hide this service?', 'ameliabooking'),
            'confirm_show_service'               => __('Are you sure you want to show this service?', 'ameliabooking'),
            'delete_category_confirmation'       => __('Are you sure you want to delete this category?', 'ameliabooking'),
            'duplicate_category_confirmation'    => __('Are you sure you want to duplicate this category?', 'ameliabooking'),
            'duration_and_pricing'               => __('Duration & Pricing ', 'ameliabooking'),
            'edit_service'                       => __('Edit Service', 'ameliabooking'),
            'edit_category'                      => __('Edit Category', 'ameliabooking'),
            'gallery'                            => __('Gallery', 'ameliabooking'),
            'hex'                                => __('Hex', 'ameliabooking'),
            'maximum_capacity'                   => __('Maximum Capacity', 'ameliabooking'),
            'maximum_capacity_tooltip'           => __('Here you can set the maximum number of people<br/>per one appointment.', 'ameliabooking'),
            'minimum_capacity'                   => __('Minimum Capacity', 'ameliabooking'),
            'minimum_capacity_tooltip'           => __('Here you can set the minimum number of people<br/>per one booking of this service.', 'ameliabooking'),
            'new_category'                       => __('New Category', 'ameliabooking'),
            'new_service'                        => __('New Service', 'ameliabooking'),
            'price'                              => __('Price', 'ameliabooking'),
            'plus_more'                          => __('+more', 'ameliabooking'),
            'select_service_duration_warning'    => __('Please select duration', 'ameliabooking'),
            'select_service_category_warning'    => __('Please select category', 'ameliabooking'),
            'service_buffer_time_after'          => __('Buffer Time After', 'ameliabooking'),
            'service_buffer_time_after_tooltip'  => __('Time after the appointment (rest, clean up, etc.),<br/>when another booking for same service and<br/>employee cannot be made.', 'ameliabooking'),
            'service_buffer_time_before'         => __('Buffer Time Before', 'ameliabooking'),
            'service_buffer_time_before_tooltip' => __('Time needed to prepare for the appointment, when<br/>another booking for same service and employee<br/>cannot be made.', 'ameliabooking'),
            'service_deleted'                    => __('Service has been deleted', 'ameliabooking'),
            'service_hidden'                     => __('Service is hidden', 'ameliabooking'),
            'service_saved'                      => __('Service has been saved', 'ameliabooking'),
            'service_visible'                    => __('Service is visible', 'ameliabooking'),
            'services_positions_saved'           => __('Services positions has been saved', 'ameliabooking'),
            'services_positions_saved_fail'      => __('Unable to save services positions', 'ameliabooking'),
            'services_sorting'                   => __('Sort Services:', 'ameliabooking'),
            'services_sorting_custom'            => __('Custom', 'ameliabooking'),
            'services_sorting_name_asc'          => __('Name Ascending', 'ameliabooking'),
            'services_sorting_name_desc'         => __('Name Descending', 'ameliabooking'),
            'services_sorting_price_asc'         => __('Price Ascending', 'ameliabooking'),
            'services_sorting_price_desc'        => __('Price Descending', 'ameliabooking'),
            'service_show_on_site'               => __('Show service on site', 'ameliabooking'),
            'service_show_on_site_tooltip'       => __('If this option is disabled, service will be available for booking from back-end pages only.', 'ameliabooking'),
            'service_recurring_cycle'            => __('Set recurring appointment', 'ameliabooking'),
            'service_recurring_cycle_tooltip'    => __('If this option is disabled, your customers won\'t be able to book recurring appointments at the same time.', 'ameliabooking'),
            'service_provider_remove_fail'       => __('Provider has appointments for this service', 'ameliabooking'),
            'service_pricing_model'              => __('Pricing model', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the user page
     *
     * @return array
     */
    public static function getUserStrings()
    {
        return [
            'create_new'               => __('Create New', 'ameliabooking'),
            'email'                    => __('Email', 'ameliabooking'),
            'enter_first_name_warning' => __('Please enter first name', 'ameliabooking'),
            'enter_last_name_warning'  => __('Please enter last name', 'ameliabooking'),
            'first_name'               => __('First Name', 'ameliabooking'),
            'last_name'                => __('Last Name', 'ameliabooking'),
            'female'                   => __('Female', 'ameliabooking'),
            'male'                     => __('Male', 'ameliabooking'),
            'notification_language'    => __('Notification Language', 'ameliabooking'),
            'select_wp_user'           => __('Select or Create New', 'ameliabooking'),
            'wp_user'                  => __('WordPress User', 'ameliabooking'),
            'wp_user_customer_tooltip' => __('Here you can map a WordPress user to the customer if<br/>you want to give customers access to the list of their<br/>appointments in the back-end of the plugin.', 'ameliabooking'),
            'wp_user_employee_tooltip' => __('Here you can map a WordPress user to the employee if<br/>you want to give employee access to the list of their<br/>appointments in the back-end of the plugin.', 'ameliabooking'),
            'wp_customer_lang_tooltip' => __('This is the language in which the customer will receive notifications for bookings made on the admin/employee panel. It is preselected if the customer has booked on a page in the language available in Amelia notifications, or it can be set here.', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the employee page
     *
     * @return array
     */
    public static function getEmployeeStrings()
    {
        return [
            'assigned_services'                => __('Assigned Services', 'ameliabooking'),
            'capacity'                         => __('Capacity', 'ameliabooking'),
            'settings_employee'                => __('Provider Settings', 'ameliabooking'),
            'employee_saved'                   => __('Employee has been saved', 'ameliabooking'),
            'employee_show_on_site'            => __('Show employee on site', 'ameliabooking'),
            'employee_show_on_site_tooltip'    => __('If this option is disabled, employee will be available for booking from back-end pages only.', 'ameliabooking'),
            'employee_panel_password'          => __('Employee Panel Password', 'ameliabooking'),
            'period_services_filter'           => __('Applied for all assigned services', 'ameliabooking'),
            'period_services_filter1_tooltip'  => __('Select only specific services for this period.<br/>If no services are selected, then all assigned services for this employee<br/>will be available for booking in this period.', 'ameliabooking'),
            'period_services_filter2_tooltip'  => __('Select specific services for each period.', 'ameliabooking'),
            'special_days_reflect_services'    => __('Reflect On', 'ameliabooking'),
            'price'                            => __('Price', 'ameliabooking'),
            'special_days'                     => __('Special Days', 'ameliabooking'),
            'service_provider_remove_fail'     => __('Provider has appointments for this service', 'ameliabooking'),
            'timezone'                         => __('Timezone', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the stripe
     *
     * @return array
     */
    public static function getStripeStrings()
    {
        return [];
    }

    /**
     * Returns the array for the customer page
     *
     * @return array
     */
    public static function getCustomerStrings()
    {
        return [
            'add_customer'                 => __('Add Customer', 'ameliabooking'),
            'confirm_delete_customer'      => __('Are you sure you want to delete this customer?', 'ameliabooking'),
            'confirm_block_customer'       => __('Are you sure you want to block this customer?', 'ameliabooking'),
            'confirm_unblock_customer'     => __('Are you sure you want to unblock this customer?', 'ameliabooking'),
            'customer_activity'            => __('Customer Activity', 'ameliabooking'),
            'customer_deleted'             => __('Customer has been deleted', 'ameliabooking'),
            'customer_blocked'             => __('Customer has been blocked', 'ameliabooking'),
            'customer_unblocked'           => __('Customer has been unblocked', 'ameliabooking'),
            'customer_note'                => __('Note', 'ameliabooking'),
            'customer_saved'               => __('Customer has been saved', 'ameliabooking'),
            'customers'                    => __('Customers', 'ameliabooking'),
            'customers_deleted'            => __('Customers have been deleted', 'ameliabooking'),
            'customers_lower'              => __('customers', 'ameliabooking'),
            'customers_search_placeholder' => __('Search Customers...', 'ameliabooking'),
            'created_on'                   => __('Created On', 'ameliabooking'),
            'date_of_birth'                => __('Date of Birth', 'ameliabooking'),
            'edit_customer'                => __('Edit Customer', 'ameliabooking'),
            'email_placeholder'            => __('example@mail.com', 'ameliabooking'),
            'events_booked'                => __('Events Booked', 'ameliabooking'),
            'export_tooltip_customers'     => __('You can use this option to export customers in CSV file.', 'ameliabooking'),
            'gender'                       => __('Gender', 'ameliabooking'),
            'import_rules_desc'            => __('<ul><li>No first row with column names</li><li><b>First</b> and <b>Last name</b> are two separate fields</li><li><b>Date of birth</b> in the same format as chosen in your WP settings (if date format with a comma is used the dates should be in quotes)</li><li><b>Phone</b> has a country code</li><li><b>Gender</b> in Male or Female form</li></ul>', 'ameliabooking'),
            'import_rules_req'             => __('Valid <b>First</b> and <b>Last name</b> are required fields. <br>If invalid, other values will be skipped and not imported.<br>If multiple customers have the same email address, only the first one will be imported.', 'ameliabooking'),
            'import_successful_desc'       => __('customers have been imported successfully to your customer list', 'ameliabooking'),
            'import_tooltip_customers'     => __('You can use this option to import customers from a CSV file.', 'ameliabooking'),
            'imported_customers'           => __('Imported customers from file:', 'ameliabooking'),
            'last_appointment'             => __('Last Appointment', 'ameliabooking'),
            'last_appointment_ascending'   => __('Last Appointment Ascending', 'ameliabooking'),
            'last_appointment_descending'  => __('Last Appointment Descending', 'ameliabooking'),
            'new_customer'                 => __('New Customer', 'ameliabooking'),
            'no_customers_yet'             => __('You don\'t have any customers here yet...', 'ameliabooking'),
            'pending_appointments'         => __('Pending Appointments', 'ameliabooking'),
            'required_data'                => __('Required fields are: <b>First Name</b> and <b>Last Name</b>.', 'ameliabooking'),
            'select_date_of_birth'         => __('Select Date of Birth', 'ameliabooking'),
            'total_appointments'           => __('Total Appointments', 'ameliabooking'),
            'upload_csv'                   => __('Upload Customers .csv file', 'ameliabooking'),
            'view_appointments'            => __('View Appointments', 'ameliabooking'),
            'view_events'                  => __('View Events', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the import dialog
     *
     * @return array
     */
    public static function getImportStrings()
    {
        return [
            'drag_drop'                    => __('Drag and drop or choose from <em>files</em>', 'ameliabooking'),
            'import_customer_data'         => __('Import customer data', 'ameliabooking'),
            'import_rules'                 => __('Import rules', 'ameliabooking'),
            'import_successful'            => __('Import successful', 'ameliabooking'),
            'map_data'                     => __('Please map corresponding data to columns.', 'ameliabooking'),
            'wrong_format'                 => __('Some records have a wrong format', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the What's new page
     *
     * @return array
     */
    public static function getWhatsNewStrings()
    {
        return [
            'welcome_to_amelia'              => __('Welcome to wpAmelia', 'ameliabooking'),
            'welcome_congratz'               => __('Congratulations! You are about to use the most powerful WordPress booking plugin - Amelia is designed to make the process of bookings representation and interaction quick, easy and effective.', 'ameliabooking'),
            'discover_amelia'                => __('Discover Amelia', 'ameliabooking'),
            'news_blog'                      => __('News Blog', 'ameliabooking'),
            'keep_up_to_date'                => __('Keep up to date!', 'ameliabooking'),
            'never_miss_notifications'       => __('Never miss notifications about new cool features, promotions, giveaways or freebies!', 'ameliabooking'),
            'enter_your_email'               => __('Enter your email', 'ameliabooking'),
            'subscribe'                      => __('Subscribe', 'ameliabooking'),
            'take_a_look'                    => __('Take a look at how our clients use Amelia', 'ameliabooking'),
            'read_success_stories'           => __('Read Success Stories', 'ameliabooking'),
            'have_questions'                 => __('Have questions?', 'ameliabooking'),
            'our_support_team'               => __('Our Support team will answer any of your questions', 'ameliabooking'),
            'contact_our_support'            => __('Contact our support', 'ameliabooking'),
            'amelia_features'                => __('Most used Premium features', 'ameliabooking'),
            'online_payments'                => __('Online Payments', 'ameliabooking'),
            'packages_services'              => __('Packages of services', 'ameliabooking'),
            'google_sync'                    => __('Google Calendar Sync', 'ameliabooking'),
            'zoom_meet'                      => __('Zoom/Google Meet', 'ameliabooking'),
            'custom_service_duration'        => __('Custom Service Duration', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the lite vs premium page
     *
     * @return array
     */
    public static function getLiteVsPremiumStrings()
    {
        return [
            'amelia_plans_comparison'       => __('Amelia Plans Comparison', 'ameliabooking'),
            'upgrade_to_premium'            => __('Upgrade to any of our three premium versions and unlock a world of exclusive features and benefits, tailored to enhance your experience and maximize the value you get from our product.', 'ameliabooking'),
            'upgrade_now'                   => __('Upgrade now', 'ameliabooking'),
            'lite_support_tooltip'          => __('Support is only available through forum', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the finance page
     *
     * @return array
     */
    public static function getFinanceStrings()
    {
        return [
            'amount'                             => __('Amount', 'ameliabooking'),
            'booking_start'                      => __('Booking Start', 'ameliabooking'),
            'customer_email'                     => __('Customer Email', 'ameliabooking'),
            'employee_email'                     => __('Employee Email', 'ameliabooking'),
            'export_tooltip_payments'            => __('You can use this option to export payments in CSV file<br/>for the selected date range.', 'ameliabooking'),
            'method'                             => __('Method', 'ameliabooking'),
            'no_payments_yet'                    => __('You don\'t have any payments here yet', 'ameliabooking'),
            'payment_date'                       => __('Payment date', 'ameliabooking'),
            'payment_created'                    => __('Payment created', 'ameliabooking'),
            'payments'                           => __('Payments', 'ameliabooking'),
            'payments_lower'                     => __('payments', 'ameliabooking'),
            'rate'                               => __('Rate', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the finance page
     *
     * @return array
     */
    public static function getPaymentStrings()
    {
        return [
            'appointment_date'         => __('Appointment Date', 'ameliabooking'),
            'appointment_info'         => __('Appointment Info', 'ameliabooking'),
            'event_date'               => __('Event Date', 'ameliabooking'),
            'confirm_delete_payment'   => __('Are you sure you want to delete this payment?', 'ameliabooking'),
            'discount_amount'          => __('Discount', 'ameliabooking'),
            'due'                      => __('Due', 'ameliabooking'),
            'enter_new_payment_amount' => __('Enter new payment amount', 'ameliabooking'),
            'finance'                  => __('Finance', 'ameliabooking'),
            'payment_deleted'          => __('Payment has been deleted', 'ameliabooking'),
            'payment_details'          => __('Payment Details', 'ameliabooking'),
            'payment_saved'            => __('Payment has been saved', 'ameliabooking'),
            'payments_deleted'         => __('Payments have been deleted', 'ameliabooking'),
            'payment_type'             => __('Payment Type', 'ameliabooking'),
            'service_price'            => __('Service Price', 'ameliabooking'),
            'subtotal'                 => __('Subtotal', 'ameliabooking'),
            'total_price'              => __('Total Price', 'ameliabooking'),
            'bookings_price'           => __('Bookings Price', 'ameliabooking'),
            'event_price'              => __('Event Price', 'ameliabooking'),
            'paid_deposit'             => __('Paid deposit', 'ameliabooking'),
            'paid_remaining_amount'    => __('Paid remaining amount', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the appointment strings
     *
     * @return array
     */
    public static function getAppointmentStrings()
    {
        return [
            'appointment_deleted'               => __('Appointment has been deleted', 'ameliabooking'),
            'appointment_saved'                 => __('Appointment has been saved', 'ameliabooking'),
            'cancel_appointment'                => __('Cancel Appointment', 'ameliabooking'),
            'appointment_rescheduled'           => __('Appointment has been rescheduled', 'ameliabooking'),
            'appointment_status_changed'        => __('Appointment status has been changed to ', 'ameliabooking'),
            'appointments_deleted'              => __('Appointments have been deleted', 'ameliabooking'),
            'appointments_search_placeholder'   => __('Search for Customers, Employees, Services...', 'ameliabooking'),
            'assigned_to'                       => __('Assigned to', 'ameliabooking'),
            'category'                          => __('Category', 'ameliabooking'),
            'change_group_status'               => __('Change group status', 'ameliabooking'),
            'confirm_delete_appointment'        => __('Are you sure you want to delete this appointment?', 'ameliabooking'),
            'confirm_delete_appointment_plural' => __('Are you sure you want to delete these appointments?', 'ameliabooking'),
            'confirm_duplicate_appointment'     => __('Are you sure you want to duplicate this appointment?', 'ameliabooking'),
            'create_customer'                   => __('Create Customer', 'ameliabooking'),
            'generate_payment_links'            => __('Generate payment links', 'ameliabooking'),
            'generate_payment_links_tooltip'    => __('Check this box to generate a payment link.<br> To include it in the notification, add the payment link placeholder.', 'ameliabooking'),
            'custom_fields'                     => __('Custom Fields', 'ameliabooking'),
            'customer_email'                    => __('Customer Email', 'ameliabooking'),
            'customer_phone'                    => __('Customer Phone', 'ameliabooking'),
            'customers_singular_plural'         => __('Customer(s)', 'ameliabooking'),
            'customers_tooltip'                 => __('Here you can define the number of people that are coming<br/>with this customer. The number you can choose depends<br/>on the service and employee capacity.', 'ameliabooking'),
            'edit_payment_details'              => __('Edit Payment Details', 'ameliabooking'),
            'edit_appointment'                  => __('Edit Appointment', 'ameliabooking'),
            'end_time'                          => __('End Time', 'ameliabooking'),
            'export_tooltip_appointments'       => __('You can use this option to export appointments in CSV file<br/>for the selected date range.', 'ameliabooking'),
            'export_tooltip_attendees'          => __('You can use this option to export attendees in CSV file<br/>for the selected event.', 'ameliabooking'),
            'new_appointment'                   => __('New Appointment', 'ameliabooking'),
            'notify_attendees'                  => __('Notify the attendee(s)', 'ameliabooking'),
            'notify_attendees_tooltip'          => __('Check this checkbox if you want your attendee(s) to<br/>receive an email about the event’s updated information.', 'ameliabooking'),
            'notify_customers'                  => __('Notify the customer(s)', 'ameliabooking'),
            'notify_customers_tooltip'          => __('Check this checkbox if you want your customer(s) to<br/>receive an email about the scheduled appointment.', 'ameliabooking'),
            'over_booking_message'              => __('By continuing, you will set the appointment to a time slot that already has an existing appointment!', 'ameliabooking'),
            'schedule'                          => __('Schedule', 'ameliabooking'),
            'select_customers'                  => __('Select Customer(s)', 'ameliabooking'),
            'select_customer_warning'           => __('Please select at least one customer', 'ameliabooking'),
            'select_max_customer_count_warning' => __('Maximum number of places is', 'ameliabooking'),
            'select_extra'                      => __('Select Extra', 'ameliabooking'),
            'select_service'                    => __('Select Service', 'ameliabooking'),
            'select_service_warning'            => __('Please select service', 'ameliabooking'),
            'select_service_category'           => __('Select Service Category', 'ameliabooking'),
            'selected_customers'                => __('Selected Customers', 'ameliabooking'),
            'service_no_extras'                 => __('This service does not have any extras', 'ameliabooking'),
            'start_time'                        => __('Start Time', 'ameliabooking'),
            'time'                              => __('Time', 'ameliabooking'),
            'time_slot_unavailable'             => __('Time slot is unavailable', 'ameliabooking'),
            'booking_cancel_exception'          => __('Appointment can\'t be canceled', 'ameliabooking'),
            'booking_reschedule_exception'      => __('Appointment can\'t be rescheduled', 'ameliabooking'),
            'booking_status_changed'            => __('Booking status has been changed to ', 'ameliabooking'),
            'wc'                                => __('WooCommerce', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the bookable strings
     *
     * @return array
     */
    public static function getBookableStrings()
    {
        return [
            'default_pricing'                    => __('Default Pricing', 'ameliabooking'),
            'deposit_enabled'                    => __('Deposit Payment', 'ameliabooking'),
            'custom_pricing_enabled'             => __('Custom Pricing', 'ameliabooking'),
            'custom_duration_pricing_enabled'    => __('Custom Duration and Pricing', 'ameliabooking'),
            'custom_person_pricing_enabled'      => __('Pricing by the number of people', 'ameliabooking'),
            'custom_period_pricing_enabled'      => __('Pricing by Day & Time', 'ameliabooking'),
            'custom_pricing'                     => __('Conditional Pricing', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the event strings
     *
     * @return array
     */
    public static function getEventStrings()
    {
        return [
            'confirm_delete_attendee'     => __('Are you sure you want to delete selected attendee?', 'ameliabooking'),
            'confirm_delete_attendees'    => __('Are you sure you want to delete selected attendees?', 'ameliabooking'),
            'confirm_delete'              => __('Are you sure you want to delete this event?', 'ameliabooking'),
            'confirm_duplicate_event'     => __('Are you sure you want to duplicate this event?', 'ameliabooking'),
            'confirm_cancel'              => __('Are you sure you want to cancel this event?', 'ameliabooking'),
            'confirm_open'                => __('Are you sure you want to open this event?', 'ameliabooking'),
            'event_cancel_before_delete'  => __('Please cancel the event first before deleting it.', 'ameliabooking'),
            'customize'                   => __('Customize', 'ameliabooking'),
            'customer_already_booked_ev'  => __('Customer is already added to this event', 'ameliabooking'),
            'pricing'                     => __('Pricing', 'ameliabooking'),
            'closed'                      => __('Closed', 'ameliabooking'),
            'full'                        => __('Full', 'ameliabooking'),
            'upcoming'                    => __('Upcoming', 'ameliabooking'),
            'edit_event'                  => __('Edit Event', 'ameliabooking'),
            'event_attendees'             => __('Attendees', 'ameliabooking'),
            'event_add_attendee'          => __('Add Attendee', 'ameliabooking'),
            'event_book_persons'          => __('Number of people', 'ameliabooking'),
            'event_book_status'           => __('Status', 'ameliabooking'),
            'event_book_tickets'          => __('Number of tickets', 'ameliabooking'),
            'event_edit_attendee'         => __('Edit Attendee', 'ameliabooking'),
            'event_aggregated_price'      => __('The price will multiply by the number of people/spots', 'ameliabooking'),
            'event_attendee_saved'        => __('Attendee has been saved', 'ameliabooking'),
            'event_attendee_remove'       => __('Remove Attendee', 'ameliabooking'),
            'event_attendees_search'      => __('Find Attendees', 'ameliabooking'),
            'event_attendee_deleted'      => __('Attendee have been deleted', 'ameliabooking'),
            'event_attendees_deleted'     => __('Attendees have been deleted', 'ameliabooking'),
            'event_book_more_than_once'   => __('Allow the same customer to book more than once', 'ameliabooking'),
            'event_bringing_anyone'       => __('Allow bringing more people', 'ameliabooking'),
            'event_cancel'                => __('Cancel Event', 'ameliabooking'),
            'event_close_after_min'       => __('Close Event after certain minimum is reached', 'ameliabooking'),
            'event_close_min_total'       => __('Minimum of attendees', 'ameliabooking'),
            'event_close_min_bookings'    => __('Minimum of bookings', 'ameliabooking'),
            'event_close_min_total_tt'    => __('One spot is equal to one attendee.', 'ameliabooking'),
            'event_close_min_bookings_tt' => __('One booking can have multiple attendees/spots in it.', 'ameliabooking'),
            'event_close_minimum'         => __('Set Minimum', 'ameliabooking'),
            'event_custom_address'        => __('Custom Address', 'ameliabooking'),
            'event_delete'                => __('Delete Event', 'ameliabooking'),
            'event_deleted'               => __('Event has been deleted', 'ameliabooking'),
            'event_duplicate'             => __('Duplicate Event', 'ameliabooking'),
            'event_name'                  => __('Name:', 'ameliabooking'),
            'event_booking_closes'        => __('Booking closes:', 'ameliabooking'),
            'event_booking_opens'         => __('Booking opens:', 'ameliabooking'),
            'event_booking_closes_on'     => __('Closes on:', 'ameliabooking'),
            'event_booking_opens_on'      => __('Opens on:', 'ameliabooking'),
            'event_booking_closes_after'  => __('Booking closes when event starts', 'ameliabooking'),
            'event_booking_opens_now'     => __('Booking opens immediately', 'ameliabooking'),
            'event_details'               => __('Details', 'ameliabooking'),
            'event_period_time'           => __('Time:', 'ameliabooking'),
            'event_open'                  => __('Open Event', 'ameliabooking'),
            'event_recurring'             => __('Recurring:', 'ameliabooking'),
            'event_recurring_enabled'     => __('This is a recurring event', 'ameliabooking'),
            'event_opened'                => __('Event has been opened', 'ameliabooking'),
            'event_canceled'              => __('Event has been canceled', 'ameliabooking'),
            'event_saved'                 => __('Event has been saved', 'ameliabooking'),
            'event_search_placeholder'    => __('Search Events...', 'ameliabooking'),
            'event_max_capacity'          => __('Maximum allowed spots', 'ameliabooking'),
            'event_select_address'        => __('Select Address', 'ameliabooking'),
            'event_staff'                 => __('Staff', 'ameliabooking'),
            'event_organizer'             => __('Organizer', 'ameliabooking'),
            'event_organizer_tooltip'     => __('Here you can choose the employee that will be added as Organizer of the Google/Outlook Event. <br>Other employees chosen under the Staff option will be added as guests.', 'ameliabooking'),
            'event_period_dates'          => __('Dates:', 'ameliabooking'),
            'event_tags'                  => __('Tags', 'ameliabooking'),
            'event_tags_select_or_create' => __('Select or Create Tag', 'ameliabooking'),
            'enter_event_name'            => __('Enter Event Name', 'ameliabooking'),
            'event_gallery'               => __('Event Gallery:', 'ameliabooking'),
            'event_colors'                => __('Event Colors:', 'ameliabooking'),
            'event_colors_preset'         => __('Preset Colors', 'ameliabooking'),
            'event_colors_custom'         => __('Custom Color', 'ameliabooking'),
            'event_show_on_site'          => __('Show event on site', 'ameliabooking'),
            'event_status_changed'        => __('Booking status has been changed to ', 'ameliabooking'),
            'no_attendees_yet'            => __('There are no attendees yet...', 'ameliabooking'),
            'new_event'                   => __('New Event', 'ameliabooking'),
            'price'                       => __('Price', 'ameliabooking'),
            'time'                        => __('Time', 'ameliabooking'),
            'maximum_capacity_reached'    => __('Maximum capacity is reached', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the calendar strings
     *
     * @return array
     */
    public static function getCalendarStrings()
    {
        return [
            'appointment_change_time'        => __('This will change the time of the appointment. Continue?', 'ameliabooking'),
            'appointment_drag_past'          => __('Appointment can\'t be moved in past time period', 'ameliabooking'),
            'appointment_rescheduled'        => __('Appointment has been rescheduled', 'ameliabooking'),
            'appointment_drag_working_hours' => __('Appointment can\'t be moved out of employee working hours', 'ameliabooking'),
            'calendar'                       => __('Calendar', 'ameliabooking'),
            'confirm'                        => __('Confirm', 'ameliabooking'),
            'total'                          => __('Total', 'ameliabooking'),
        ];
    }

    /**
     * Returns the array for the Customize page
     *
     * @return array
     */
    public static function getCustomizeStrings()
    {
        return [
            'add_custom_field'                   => __('Add Custom Field', 'ameliabooking'),
            'add_extra'                          => __('Add Extra', 'ameliabooking'),
            'address'                            => __('Address', 'ameliabooking'),
            'are_you_sure_reset_customize'       => __('Are you sure you want to reset your form settings?', 'ameliabooking'),
            'current_changes_will_be_lost'       => __('Your current changes will be lost.', 'ameliabooking'),
            'reset_yes'                          => __('Yes, Reset', 'ameliabooking'),
            'reset_no'                           => __('No, Cancel', 'ameliabooking'),
            'reset_form'                         => __('Reset Form', 'ameliabooking'),
            'package_available'                  => __('Available in package', 'ameliabooking'),
            'bringing_anyone_with_you'           => __('Bringing Anyone with You?', 'ameliabooking'),
            'buttons'                            => __('Buttons', 'ameliabooking'),
            'package_discount_text'              => __('Save', 'ameliabooking'),
            'default_label'                      => __('Default Label', 'ameliabooking'),
            'duration_colon'                     => __('Duration', 'ameliabooking'),
            'checkbox'                           => __('Checkbox', 'ameliabooking'),
            'click_add_custom_field'             => __('Start by clicking the Add Custom Field button', 'ameliabooking'),
            'text_content'                       => __('Text Content', 'ameliabooking'),
            'custom_fields'                      => __('Custom Fields', 'ameliabooking'),
            'customize'                          => __('Customize', 'ameliabooking'),
            'font'                               => __('Font', 'ameliabooking'),
            'no_custom_fields_yet'               => __('You don\'t have any custom fields here yet...', 'ameliabooking'),
            'options'                            => __('Options', 'ameliabooking'),
            'pick_date_and_time'                 => __('Pick date & time', 'ameliabooking'),
            'please_select_service'              => __('Please select service', 'ameliabooking'),
            'primary_color'                      => __('Primary Color', 'ameliabooking'),
            'success_color'                      => __('Success Color', 'ameliabooking'),
            'warning_color'                      => __('Warning Color', 'ameliabooking'),
            'error_color'                        => __('Error Color', 'ameliabooking'),
            'radio'                              => __('Radio Buttons', 'ameliabooking'),
            'reset'                              => __('Reset', 'ameliabooking'),
            'select'                             => __('Selectbox', 'ameliabooking'),
            'steps'                              => __('Steps', 'ameliabooking'),
            'select_service'                     => __('Select Service', 'ameliabooking'),
            'text'                               => __('Text', 'ameliabooking'),
            'text-area'                          => __('Text Area', 'ameliabooking'),
            'text_color'                         => __('Text Color', 'ameliabooking'),
            'placeholder_color'                  => __('Placeholder Color', 'ameliabooking'),
            'text_color_on_background'           => __('Text Color on Background', 'ameliabooking'),
            'file'                               => __('Attachment', 'ameliabooking'),
            'datepicker'                         => __('Date Picker', 'ameliabooking'),
            'preview'                            => __('Preview', 'ameliabooking'),
            'bgr_color'                          => __('Background Color', 'ameliabooking'),
            'bgr_gradient_color1'                => __('Background Gradient Color 1', 'ameliabooking'),
            'bgr_gradient_color2'                => __('Background Gradient Color 2', 'ameliabooking'),
            'bgr_gradient_angle'                 => __('Background Gradient Angle', 'ameliabooking'),
            'input_color'                        => __('Input Color', 'ameliabooking'),
            'input_text_color'                   => __('Input Text Color', 'ameliabooking'),
            'dropdown_color'                     => __('Dropdown Color', 'ameliabooking'),
            'dropdown_text_color'                => __('Dropdown Text Color', 'ameliabooking'),
            'image_color'                        => __('Image Color', 'ameliabooking'),
            'recurring_active'                   => __('Repeat this appointment', 'ameliabooking'),
            'first_name_colon'                   => __('First Name', 'ameliabooking'),
            'last_name_colon'                    => __('Last Name', 'ameliabooking'),
            'last_name_input_field'              => __('Last Name Input Field', 'ameliabooking'),
            'email_colon'                        => __('Email', 'ameliabooking'),
            'email_input_field'                  => __('Email Input Field', 'ameliabooking'),
            'phone_colon'                        => __('Phone', 'ameliabooking'),
            'phone_input_field'                  => __('Phone Input Field', 'ameliabooking'),
            'go_back'                            => __('Go Back', 'ameliabooking'),
            'service_name'                       => __('Service name', 'ameliabooking'),
            'display_field'                      => __('Display Field:', 'ameliabooking'),
            'filterable_field'                   => __('Filterable Field:', 'ameliabooking'),
            'mandatory_field'                    => __('Mandatory Field:', 'ameliabooking'),
            'event_type'                         => __('Event Type', 'ameliabooking'),
            'event_location'                     => __('Event Location', 'ameliabooking'),
            'open'                               => __('Open', 'ameliabooking'),
            'full'                               => __('Full', 'ameliabooking'),
            'upcoming'                           => __('Upcoming', 'ameliabooking'),
            'event_free'                         => __('Free', 'ameliabooking'),
            'event_price'                        => __('Event Price', 'ameliabooking'),
            'service_badge'                      => __('Service Badge', 'ameliabooking'),
            'service_price'                      => __('Service Price', 'ameliabooking'),
            'package_name'                       => __('Package Name', 'ameliabooking'),
            'congratulations'                    => __('Congratulations!', 'ameliabooking'),
            'add_to_calendar'                    => __('Add to Calendar', 'ameliabooking'),
            'finish_appointment'                 => __('Finish', 'ameliabooking'),
            'form_type_step_by_step'             => __('Step By Step Booking Form', 'ameliabooking'),
            'event_status'                       => __('Event Status', 'ameliabooking'),
            'event_filters'                      => __('Filters', 'ameliabooking'),
            'event_book_event'                   => __('Book event', 'ameliabooking'),
            'form_block_service'                 => __('Service', 'ameliabooking'),
            'form'                               => __('Form', 'ameliabooking'),
            'form_flow'                          => __('Form Flow', 'ameliabooking'),
            'use_global_colors'                  => __('Use Global Colors', 'ameliabooking'),
            'service_selection'                  => __('Service Selection', 'ameliabooking'),
            'employee_selection'                 => __('Employee Selection', 'ameliabooking'),
            'location_selection'                 => __('Location Selection', 'ameliabooking'),
            'service_colon'                      => __('Service', 'ameliabooking'),
            'dropdown_category_heading'          => __('Category', 'ameliabooking'),
            'dropdown_items_heading'             => __('Service', 'ameliabooking'),
            'dropdown_empty'                     => __('No matching data', 'ameliabooking'),

            'bringing_anyone'                    => __('Bringing Anyone With You', 'ameliabooking'),
            'show_more'                          => __('Show more', 'ameliabooking'),
            'show_less'                          => __('Show less', 'ameliabooking'),

            'date_time'                          => __('Date & Time', 'ameliabooking'),
            'date_time_slots_selected'           => __('All slots are selected', 'ameliabooking'),
            'info_step'                          => __('Your Information', 'ameliabooking'),
            'enter_first_name'                   => __('Enter first name', 'ameliabooking'),
            'enter_first_name_warning'           => __('Please enter first name', 'ameliabooking'),
            'enter_last_name'                    => __('Enter last name', 'ameliabooking'),
            'enter_last_name_warning'            => __('Please enter last name', 'ameliabooking'),
            'enter_email'                        => __('Enter email', 'ameliabooking'),
            'enter_valid_email_warning'          => __('Please enter valid email', 'ameliabooking'),
            'enter_phone'                        => __('Enter phone', 'ameliabooking'),
            'enter_phone_warning'                => __('Please enter phone', 'ameliabooking'),

            'payment_step'                       => __('Payment', 'ameliabooking'),
            'summary'                            => __('Summary', 'ameliabooking'),
            'summary_services'                   => __('Services', 'ameliabooking'),
            'summary_services_subtotal'          => __('Service Subtotal', 'ameliabooking'),
            'summary_persons'                    => __('people', 'ameliabooking'),
            'subtotal'                           => __('Subtotal', 'ameliabooking'),
            'total_amount_colon'                 => __('Total Amount', 'ameliabooking'),
            'payment_onsite_sentence'            => __('The payment will be done on-site.', 'ameliabooking'),
            'appointment_id'                     => __('Appointment ID', 'ameliabooking'),
            'congrats_total_amount'              => __('Total Amount', 'ameliabooking'),
            'congrats_payment'                   => __('Payment', 'ameliabooking'),
            'your_name_colon'                    => __('Your Name', 'ameliabooking'),
            'email_address_colon'                => __('Email Address', 'ameliabooking'),
            'phone_number_colon'                 => __('Phone Number', 'ameliabooking'),
            'congrats_date'                      => __('Date', 'ameliabooking'),
            'congrats_time'                      => __('Local Time', 'ameliabooking'),
            'congrats_service'                   => __('Service', 'ameliabooking'),
            'congrats_employee'                  => __('Employee', 'ameliabooking'),
            'congrats_location'                  => __('Location', 'ameliabooking'),
            'choose_form'                        => __('Choose a Form', 'ameliabooking'),
            'choose_form_for_customize'          => __('Choose a form you want to customize. The Step-by-Step 2.0 form is the new and improved version which provides you with better design and user experience, as well as better speed.', 'ameliabooking'),
            'sbs_booking_form'                   => __('Step-by-Step Booking Form 2.0', 'ameliabooking'),
            'sbs_booking_form_old'               => __('Booking Forms 1.0', 'ameliabooking'),
            'redesigned_sbs_booking_form'        => __('Use the upgraded Step-by-Step Booking Form 2.0 for a simplified, direct booking process on your page. Customize its design and labels to enhance user experience and meet your business needs.', 'ameliabooking'),
            'old_forms_text'                     => __('The original booking forms—Step-by-Step, Catalog, Event List, and Event Calendar—feature basic customization and label changes, serving as the foundation for our newer versions.', 'ameliabooking'),
            'primary_and_state_colors'           => __('Primary and state colors', 'ameliabooking'),
            'sidebar'                            => __('Sidebar', 'ameliabooking'),
            'background_color'                   => __('Background Color', 'ameliabooking'),
            'content'                            => __('Content', 'ameliabooking'),
            'heading_text_color'                 => __('Heading Text Color', 'ameliabooking'),
            'content_text_color'                 => __('Content Text Color', 'ameliabooking'),
            'input_fields'                       => __('Input Fields', 'ameliabooking'),
            'border_color'                       => __('Border Color', 'ameliabooking'),
            'dropdowns'                          => __('Dropdowns', 'ameliabooking'),
            'init_cell'                          => __('Init Cell', 'ameliabooking'),
            'init_cell_text'                     => __('Init Cell Text', 'ameliabooking'),
            'lower_price'                        => __('(Lower Price)', 'ameliabooking'),
            'higher_price'                       => __('(Higher Price)', 'ameliabooking'),
            'cell_selected_background'           => __('Cell Selected Background', 'ameliabooking'),
            'cell_selected_text'                 => __('Cell Selected Text', 'ameliabooking'),
            'cell_disabled_background'           => __('Cell Disabled Background', 'ameliabooking'),
            'cell_disabled_text'                 => __('Cell Disabled Text', 'ameliabooking'),
            'primary_background'                 => __('Primary Button Background Color', 'ameliabooking'),
            'primary_text'                       => __('Primary Button Text Color', 'ameliabooking'),
            'secondary_background'               => __('Secondary Button Background Color', 'ameliabooking'),
            'secondary_text'                     => __('Secondary Button Text Color', 'ameliabooking'),
            'danger_background'                  => __('Danger Button Background Color', 'ameliabooking'),
            'danger_text'                        => __('Danger Button Text Color', 'ameliabooking'),
            'layout_and_inputs'                  => __('Layout & Inputs', 'ameliabooking'),
            'colors'                             => __('Colors', 'ameliabooking'),
            'fonts'                              => __('Fonts', 'ameliabooking'),
            'order'                              => __('Order', 'ameliabooking'),
            'step_title'                         => __('Step Title', 'ameliabooking'),
            'footer_buttons'                     => __('Footer Buttons', 'ameliabooking'),
            'step_content'                       => __('Step Content', 'ameliabooking'),
            'finish_btn_type'                    => __('Finish Button Type', 'ameliabooking'),
            'panel_btn_type'                     => __('Panel Button Type', 'ameliabooking'),
            'summary_segment'                    => __('Summary Segment', 'ameliabooking'),
            'payment_segment'                    => __('Payment Segment', 'ameliabooking'),
            'heading_title'                      => __('Heading Title', 'ameliabooking'),
            'sub_steps'                          => __('Sub Steps', 'ameliabooking'),
            'step_popups'                        => __('Step Popups', 'ameliabooking'),

            /* csb - customize side bar */
            'csb_global_settings_content'        => __('Fonts and colors', 'ameliabooking'),
            'csb_sidebar_content'                => __('Set up Sidebar visibility and its content', 'ameliabooking'),
            'csb_services'                       => __('Service Selection', 'ameliabooking'),
            'csb_services_content'               => __('Set up Services, Locations, Employees selection options', 'ameliabooking'),
            'csb_services_only_content'          => __('Set up Services selection options', 'ameliabooking'),
            'csb_employees'                      => __('Employees Selection', 'ameliabooking'),
            'csb_employees_only_content'         => __('Set up Employees selection options', 'ameliabooking'),
            'csb_locations'                      => __('Locations Selection', 'ameliabooking'),
            'csb_locations_only_content'         => __('Set up Locations selection options', 'ameliabooking'),
            'csb_date_time'                      => __('Date & Time Selection', 'ameliabooking'),
            'csb_date_time_content'              => __('Set up Calendar layout and Recurring popup options', 'ameliabooking'),
            'csb_info_step'                      => __('Customer Information', 'ameliabooking'),
            'csb_info_step_content'              => __('Field order, mandatory fields, labels and display options', 'ameliabooking'),
            'csb_payment'                        => __('Payment Summary', 'ameliabooking'),
            'csb_payment_content'                => __('Set up labels and buttons', 'ameliabooking'),
            'cpb_congratulations_content'        => __('Set up button types and labels', 'ameliabooking'),
            'plus_more'                          => __('+more', 'ameliabooking'),

            'cb_global_settings_heading'         => __('Global Settings', 'ameliabooking'),
            'cb_sidebar'                         => __('Sidebar', 'ameliabooking'),
            'cb_section'                         => __('Section', 'ameliabooking'),
            'cb_field_order_heading'             => __('Field Order', 'ameliabooking'),
            'cb_congratulations_heading'         => __('Congratulations', 'ameliabooking'),

            'sidebar_footer'                     => __('Footer', 'ameliabooking'),
            'get_in_touch'                       => __('Get in Touch', 'ameliabooking'),
            'collapse_menu'                      => __('Collapse Menu', 'ameliabooking'),

            'sb_radio_filled'                    => __('Filled', 'ameliabooking'),
            'sb_radio_plain'                     => __('Plain', 'ameliabooking'),
            'sb_radio_text'                      => __('Text', 'ameliabooking'),

            'continue_button_type'               => __('Continue Button Type', 'ameliabooking'),
            'calendar_slot_end_time'             => __('Calendar Slot End Time', 'ameliabooking'),
            'show_busy_slots'                    => __('Show Busy Time Slots', 'ameliabooking'),
            'show_estimated_pricing'             => __('Show Estimated Price', 'ameliabooking'),
            'show_slot_pricing'                  => __('Show Time Slot Price', 'ameliabooking'),
            'show_indicator_pricing'             => __('Show Price Indicators', 'ameliabooking'),
            'calendar_time_zone'                 => __('Calendar Time Zone', 'ameliabooking'),
            'first_name'                         => __('First Name', 'ameliabooking'),
            'last_name'                          => __('Last Name', 'ameliabooking'),
            'email'                              => __('Email', 'ameliabooking'),
            'phone'                              => __('Phone', 'ameliabooking'),
            'finish_button_type'                 => __('Finish Button Type', 'ameliabooking'),
            'panel_button_type'                  => __('Panel Button Type', 'ameliabooking'),
            'sidebar_visibility'                 => __('Sidebar Visibility', 'ameliabooking'),
            'publish_form'                       => __('Publish Form', 'ameliabooking'),

            'view_all'                           => __('View All', 'ameliabooking'),
            'csb_categories'                     => __('Categories', 'ameliabooking'),
            'csb_categories_content'             => __('Set up categories cards', 'ameliabooking'),
            'cards'                              => __('Cards', 'ameliabooking'),
            'card_button_type'                   => __('Card Button Type', 'ameliabooking'),
            'csb_category_services'              => __('Services Overview', 'ameliabooking'),
            'csb_category_services_content'      => __('Set up Services view', 'ameliabooking'),
            'csb_category_service'               => __('Service Details', 'ameliabooking'),
            'csb_category_service_content'       => __('Set up Service detailed view', 'ameliabooking'),
            'booking_form'                       => __('Booking Form', 'ameliabooking'),
            'booking_form_content'               => __('Set options, colors and labels for booking form', 'ameliabooking'),

            'cat_booking_form'                   => __('Catalog Booking Form 2.0', 'ameliabooking'),
            'redesigned_cat_booking_form'        => __(' Discover the modernized Catalog Booking Form 2.0 that showcases services in stylish card layouts. Easily add categories and adjust the appearance to reflect your brand.', 'ameliabooking'),

            // cl - categories list
            'card_services_number'               => __('Total Number of Services', 'ameliabooking'),
            'back_btn_heading'                   => __('Back Button', 'ameliabooking'),
            'back_btn_type'                      => __('“Back” Button Type', 'ameliabooking'),
            'back_btn'                           => __('Go Back', 'ameliabooking'),
            'booking_btn_type'                   => __('“Book Now” Button Type', 'ameliabooking'),

            // cl - category list
            'cl_btn'                             => __('Main Category Button', 'ameliabooking'),
            'cl_side_color'                      => __('Category Card Side Color', 'ameliabooking'),
            'cl_color'                           => __('Category Color', 'ameliabooking'),

            // cli - category items list
            // keys only used on backend customize
            'cil_filter_menu_btn'                => __('Filter Menu Button Type', 'ameliabooking'),
            'cil_sidebar'                        => __('Categories Sidebar', 'ameliabooking'),
            'cil_filter_block'                   => __('Filters Block', 'ameliabooking'),
            'cil_side_menu_block'                => __('Categories Sidebar', 'ameliabooking'),
            'cil_main_header'                    => __('Page Header', 'ameliabooking'),
            'cil_main_content'                   => __('Main Content', 'ameliabooking'),
            'service_category'                   => __('Service Category', 'ameliabooking'),
            'service_duration'                   => __('Service Duration', 'ameliabooking'),
            'service_about'                      => __('About Service', 'ameliabooking'),
            'cil_filter_input'                   => __('“Search” option', 'ameliabooking'),
            'cli_item_color'                     => __('Card Color', 'ameliabooking'),
            'page_scroll_visibility'             => __('Page Scroll Visibility', 'ameliabooking'),

            'filter_input'                       => __('Search', 'ameliabooking'),
            'available'                          => __('Available', 'ameliabooking'),
            'heading_service'                    => __('Service', 'ameliabooking'),
            'heading_services'                   => __('Services', 'ameliabooking'),
            'no_search_data'                     => __('No results', 'ameliabooking'),
            'free'                               => __('Free', 'ameliabooking'),
            'book_now'                           => __('Book Now', 'ameliabooking'),
            'about_service'                      => __('About Service', 'ameliabooking'),
            'view_all_photos'                    => __('View all photos', 'ameliabooking'),

            'support_heading'                    => __('Support Heading:', 'ameliabooking'),
            'company_phone'                      => __('Company Phone:', 'ameliabooking'),
            'company_email'                      => __('Company Email:', 'ameliabooking'),

            // elf - event list form
            'elf_booking_form'                   => __('Event List Booking Form 2.0', 'ameliabooking'),
            'redesigned_elf_booking_form'        => __('The Event List Booking Form 2.0 offers an intuitive and fast booking experience, with a design that stands out. Customers can effortlessly browse and book from a list of events.', 'ameliabooking'),

            'csb_events_list'                    => __('Events List', 'ameliabooking'),
            'csb_events_list_content'            => __('Set up Location, Images, Filters, Capacity, Price, and Status visibility options', 'ameliabooking'),
            'csb_event_info'                     => __('Event Info', 'ameliabooking'),
            'csb_event_info_content'             => __('Set up Staff, Location, Gallery and other Event information visibility', 'ameliabooking'),
            'csb_event_customer'                 => __('Customer Info', 'ameliabooking'),
            'csb_event_customer_content'         => __('Field order, mandatory fields, labels and display options', 'ameliabooking'),
            'csb_event_payment'                  => __('Payment', 'ameliabooking'),
            'csb_event_payment_content'          => __('Set up labels and buttons', 'ameliabooking'),
            'csb_event_congratulations'          => __('Congratulations', 'ameliabooking'),
            'csb_event_congratulations_content'  => __('Set up button types and labels', 'ameliabooking'),

            'events_available'                   => __('Events Available', 'ameliabooking'),
            'event_available'                    => __('Event Available', 'ameliabooking'),
            'event_page'                         => __('Page', 'ameliabooking'),
            'event_search'                       => __('Search for Events', 'ameliabooking'),
            'event_begins'                       => __('Begins', 'ameliabooking'),
            'event_slot_left'                    => __('slot left', 'ameliabooking'),
            'event_slots_left'                   => __('slots left', 'ameliabooking'),
            'event_learn_more'                   => __('Learn more', 'ameliabooking'),
            'event_read_more'                    => __('Read more', 'ameliabooking'),
            'event_close'                        => __('Close', 'ameliabooking'),
            'event_customer_info'                => __('Your Information', 'ameliabooking'),
            'summary_event'                      => __('Event', 'ameliabooking'),
            'event_id'                           => __('Event ID', 'ameliabooking'),
            'about'                              => __('About', 'ameliabooking'),
            'event_info'                         => __('Event Info', 'ameliabooking'),
            'event_timetable'                    => __('Timetable', 'ameliabooking'),
            'event_payment'                      => __('Payment', 'ameliabooking'),
            'event_congrats'                     => __('Congratulations', 'ameliabooking'),
            'event_about_list'                   => __('About Event', 'ameliabooking'),
            'event_start'                        => __('Event Starts', 'ameliabooking'),
            'event_end'                          => __('Event Ends', 'ameliabooking'),
            'event_at'                           => __('at', 'ameliabooking'),
            'event_bringing'                     => __('How many attendees do you want to book event for?', 'ameliabooking'),

            // strings used only on backend
            'step_filters'                       => __('Step Filters', 'ameliabooking'),
            'event_card'                         => __('Event Card', 'ameliabooking'),
            'step_pagination'                    => __('Step Pagination', 'ameliabooking'),
            'event_slots_capacity'               => __('Event Slots Capacity', 'ameliabooking'),
            'filters_button_type'                => __('Filters Button Type', 'ameliabooking'),
            'read_more_button_type'              => __('Read More Button Type', 'ameliabooking'),
            'learn_more_button_type'             => __('Learn More Button Type', 'ameliabooking'),
            'event_tab_img'                      => __('Event Tab Image', 'ameliabooking'),
            'step_header'                        => __('Step Header', 'ameliabooking'),
            'step_info_tab'                      => __('Step Info Tab', 'ameliabooking'),
            'booking_event_btn'                  => __('Booking Event Button', 'ameliabooking'),
            'finish_event_btn'                   => __('Finish Button', 'ameliabooking'),
            'close_event_btn'                    => __('Close Event Button', 'ameliabooking'),
            'event_gallery'                      => __('Event Gallery', 'ameliabooking'),
            'event_description'                  => __('Event Description', 'ameliabooking'),

            'summary_person'                     => __('person', 'ameliabooking'),
            'event_employees'                    => __('Event Employees', 'ameliabooking'),

            'learn_more'                         => __('Learn More', 'ameliabooking'),
            'service_information'                => __('Service information', 'ameliabooking'),
            'learn_more_button'                  => __('Learn more button', 'ameliabooking'),
            'location_address'                   => __('Location Address', 'ameliabooking'),
            'no_results_found'                   => __('No results found...', 'ameliabooking'),
            'card_field'                         => __('Card Field', 'ameliabooking'),
            'popup_content'                      => __('Popup Content', 'ameliabooking'),
            'employees'                          => __('Employees', 'ameliabooking'),
            'layout'                             => __('Layout', 'ameliabooking'),
            'search_input_field'                 => __('Search Input Field', 'ameliabooking'),
            'category_input_field'               => __('Category Input Field', 'ameliabooking'),
            'select_service_category'            => __('Select Service Category', 'ameliabooking'),
        ];
    }

    /**
     * @return array
     */
    public static function getWordPressStrings()
    {
        return [
            'catalog'                          => __('Catalog', 'ameliabooking'),
            'choose_category'                  => __('Choose Category', 'ameliabooking'),
            'choose_service'                   => __('Choose Service', 'ameliabooking'),
            'choose_package'                   => __('Choose Package', 'ameliabooking'),
            'filter'                           => __('Preselect Booking Parameters', 'ameliabooking'),
            'skip_categories'                  => __('Skip Categories step', 'ameliabooking'),
            'insert_amelia_shortcode'          => __('Insert Amelia Booking Shortcode', 'ameliabooking'),
            'select_catalog_view'              => __('Select Catalog View', 'ameliabooking'),
            'select_category'                  => __('Select Category', 'ameliabooking'),
            'select_employee'                  => __('Select Employee', 'ameliabooking'),
            'select_location'                  => __('Select Location', 'ameliabooking'),
            'select_package'                   => __('Select Package', 'ameliabooking'),
            'select_service'                   => __('Select Service', 'ameliabooking'),
            'select_event'                     => __('Select Event', 'ameliabooking'),
            'select_events'                    => __('Select Events', 'ameliabooking'),
            'select_tag'                       => __('Select Tag', 'ameliabooking'),
            'select_tags'                      => __('Select Tags', 'ameliabooking'),
            'select_view'                      => __('Select View', 'ameliabooking'),
            'show'                             => __('Show', 'ameliabooking'),
            'show_all'                         => __('Show All', 'ameliabooking'),
            'manually_loading'                 => __('Load booking form manually', 'ameliabooking'),
            'manually_loading_description'     => __('Add element (button, link...) ID, that will manually load amelia shortcode content', 'ameliabooking'),
            'multiselect_note'                 => __('For multiselect: hold CTRL / Command (⌘).', 'ameliabooking'),
            'show_all_categories'              => __('Show all categories', 'ameliabooking'),
            'show_all_employees'               => __('Show all employees', 'ameliabooking'),
            'show_all_locations'               => __('Show all locations', 'ameliabooking'),
            'show_all_services'                => __('Show all services', 'ameliabooking'),
            'show_all_events'                  => __('Show all events', 'ameliabooking'),
            'show_all_packages'                => __('Show all packages', 'ameliabooking'),
            'show_all_tags'                    => __('Show all tags', 'ameliabooking'),
            'show_catalog'                     => __('Show catalog of all categories', 'ameliabooking'),
            'show_category'                    => __('Show specific category', 'ameliabooking'),
            'show_categories'                  => __('Show specific categories', 'ameliabooking'),
            'show_package'                     => __('Show specific package', 'ameliabooking'),
            'show_packages'                    => __('Show specific packages', 'ameliabooking'),
            'show_event'                       => __('Show event', 'ameliabooking'),
            'show_event_view_type'             => __('Show Type', 'ameliabooking'),
            'show_event_view_list'             => __('List (default)', 'ameliabooking'),
            'show_event_view_calendar'         => __('Calendar', 'ameliabooking'),
            'show_tag'                         => __('Show tag', 'ameliabooking'),
            'show_service'                     => __('Show specific service', 'ameliabooking'),
            'show_services'                    => __('Show specific services', 'ameliabooking'),
            'trigger_type'                     => __('Trigger type', 'ameliabooking'),
            'trigger_type_id'                  => __('Id', 'ameliabooking'),
            'trigger_type_class'               => __('Class', 'ameliabooking'),
            'trigger_type_tooltip'             => __('Trigger by attribute', 'ameliabooking'),
            'step_booking'                     => __('Step Booking', 'ameliabooking'),
            'catalog_booking'                  => __('Catalog Booking', 'ameliabooking'),
            'events_list_booking'              => __('Events List Booking', 'ameliabooking'),
            'recurring_event'                  => __('Show recurring events', 'ameliabooking'),
            'in_dialog'                        => __('Show in Amelia Popup', 'ameliabooking'),

            'booking_divi'                     => __('AM - Booking view', 'ameliabooking'),
            'step_booking_divi'                => __('AM - Step Booking', 'ameliabooking'),
            'catalog_booking_divi'             => __('AM - Catalog Booking', 'ameliabooking'),
            'catalog_divi'                     => __('AM - Catalog view', 'ameliabooking'),
            'events_divi'                      => __('AM - Events view', 'ameliabooking'),
            'events_list_booking_divi'         => __('AM - Events List Booking', 'ameliabooking'),
            'events_calendar_booking_divi'     => __('AM - Events Calendar Booking', 'ameliabooking'),
            'booking_gutenberg_block'          => [
                'title'       => __('Amelia - Booking view', 'ameliabooking'),
                'description' => __('Step-By-Step Booking Wizard gives your customers the option to choose everything about the booking in a few steps', 'ameliabooking'),
            ],
            'step_booking_gutenberg_block'          => [
                'title'       => __('Amelia - Step-By-Step Booking', 'ameliabooking'),
                'description' => __('Step-by-Step booking view guides the customers through several steps in order to make their bookings.', 'ameliabooking'),
            ],
            'catalog_booking_gutenberg_block'          => [
                'title'       => __('Amelia - Catalog Booking', 'ameliabooking'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a catalog', 'ameliabooking'),
            ],
            'catalog_gutenberg_block'          => [
                'title'       => __('Amelia - Catalog view', 'ameliabooking'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a cataloge', 'ameliabooking'),
            ],
            'events_gutenberg_block'           => [
                'title'       => __('Amelia - Events', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'ameliabooking'),
            ],
            'events_list_booking_gutenberg_block'           => [
                'title'       => __('Amelia - Events List', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'ameliabooking'),
            ],
            'events_calendar_booking_gutenberg_block'           => [
                'title'       => __('Amelia - Events Calendar', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event calendar view.', 'ameliabooking'),
            ],
            'outdated_booking_gutenberg_block' => __('You are using a form that will be outdated soon!', 'ameliabooking'),
        ];
    }

    /**
     * @return array
     */
    public static function getBuddyBossStrings()
    {
        return [
        ];
    }

    /**
     * @return array
     */
    public static function getRecurringStrings()
    {
        return [
            'recurring_appointments'   => __('Recurring Appointments', 'ameliabooking'),
        ];
    }
}
