<?php
/**
 * @package     WordPress
 * @subpackage  Luxury Spa Child
 * @version     1.3.0
 */

// ------------------------------
// 1️⃣ Enqueue child theme styles
// ------------------------------
function luxury_spa_enqueue_styles() {
    wp_enqueue_style('luxury-spa-child-style', get_stylesheet_uri(), array(), '1.3.0', 'screen, print');
}
add_action('wp_enqueue_scripts', 'luxury_spa_enqueue_styles', 11);


// ------------------------------
// 2️⃣ Replace WooCommerce "Add to Cart" button with "Book Now"
// ------------------------------
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action('woocommerce_after_shop_loop_item', 'custom_book_now_button', 10);

function custom_book_now_button() {
    global $product;
    if (!$product || !is_a($product, 'WC_Product')) return;

    $popup_id = 14176; // Change to your Popup Maker ID
    $product_name = esc_attr($product->get_name());

    // Get first category ID of the product
    $categories = wp_get_post_terms($product->get_id(), 'product_cat', array('fields' => 'ids'));
    $category_id = $categories[0] ?? 0;

    echo '<a href="#" 
        class="button book-now pum-trigger" 
        data-popup="' . esc_attr($popup_id) . '" 
        data-product="' . esc_attr($product_name) . '" 
        data-product-id="' . esc_attr($product->get_id()) . '" 
        data-category-id="' . esc_attr($category_id) . '" 
        style="cursor:pointer; display:inline-block; margin-top:10px;">
        Book Now
    </a>';
}


// ------------------------------
// 3️⃣ Create custom bookings table
// ------------------------------
function create_custom_bookings_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'custom_bookings';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        services text NOT NULL,
        name varchar(255) NOT NULL,
        email varchar(255) NOT NULL,
        phone varchar(50) NOT NULL,
        date date NOT NULL,
        created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate AUTO_INCREMENT=1001;"; // Start from 1001

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
add_action('after_setup_theme', 'create_custom_bookings_table');


// ------------------------------
// 4️⃣ Enqueue scripts and styles
// ------------------------------
function enqueue_custom_booking_scripts() {
    wp_enqueue_script('jquery-ui-datepicker');
    wp_enqueue_style('jquery-ui-css', 'https://code.jquery.com/ui/1.13.2/themes/smoothness/jquery-ui.css');

    wp_enqueue_script('flatpickr-js', 'https://cdn.jsdelivr.net/npm/flatpickr', array('jquery'), null, true);
    wp_enqueue_style('flatpickr-css', 'https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css');

    wp_enqueue_script(
        'custom-booking-js',
        get_stylesheet_directory_uri() . '/js/custom-booking.js', // We'll create this next
        array('jquery', 'popup-maker-site', 'flatpickr-js'),
        '1.0',
        true
    );

    wp_localize_script(
        'custom-booking-js',
        'custom_booking_ajax',
        array('ajax_url' => admin_url('admin-ajax.php'))
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_booking_scripts');


// ------------------------------
// 5️⃣ Booking form shortcode
// ------------------------------
function custom_booking_form_shortcode($atts) {
    global $post;

    ob_start(); ?>
    <div id="booking-message" style="margin-top:10px;color:green;"></div>
    <div id="booking-form-wrapper">

    <form id="custom-booking-form" class="custom-booking-ajax" method="post">
        <h2 style="text-align:center;">Booking Form</h2>
        <p><strong>Select Services:</strong></p>
        <div id="services-list"></div>

        <label for="date">Select Date</label>
        <input type="text" name="date" id="booking-date" placeholder="Select your date" required>

        <label for="name">Full Name</label>
        <input type="text" name="name" required>

        <label for="email">Email</label>
        <input type="email" name="email" required>

        <label for="phone">Phone</label>
        <input type="tel" name="phone" required>

        <button type="submit" name="submit_booking">Confirm Booking</button>
    </form>
</div>
    
    <?php
    return ob_get_clean();
}
add_shortcode('custom_booking_form', 'custom_booking_form_shortcode');


// ------------------------------
// 6️⃣ AJAX: Handle booking submission
// ------------------------------
function handle_custom_booking_ajax() {
    global $wpdb;
    $table = $wpdb->prefix . 'custom_bookings';

    $services = $_POST['services'] ?? [];
    $name     = sanitize_text_field($_POST['name'] ?? '');
    $email    = sanitize_email($_POST['email'] ?? '');
    $phone    = sanitize_text_field($_POST['phone'] ?? '');
    $date     = sanitize_text_field($_POST['date'] ?? '');

    if(empty($services) || empty($name) || empty($email) || empty($phone) || empty($date)){
        wp_send_json_error('Please fill in all fields.');
    }

    $services_list = implode(', ', array_map('sanitize_text_field', $services));

    // Insert booking into DB
    $wpdb->insert($table, [
        'services'   => $services_list,
        'name'       => $name,
        'email'      => $email,
        'phone'      => $phone,
        'date'       => $date,
        'created_at' => current_time('mysql')
    ]);

    // Get Booking ID
    $booking_id = $wpdb->insert_id;

    // Prepare HTML email with booking ID
    $recipient = 'pvignesh.mca54@gmail.com';
    $subject = 'New Booking Received';
    $message = '
    <html>
    <head>
      <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
      </style>
    </head>
    <body>
      <h2>New Booking Received</h2>
      <table>
        <tr><th>Booking ID</th><td>' . $booking_id . '</td></tr>
        <tr><th>Services</th><td>' . $services_list . '</td></tr>
        <tr><th>Name</th><td>' . $name . '</td></tr>
        <tr><th>Email</th><td>' . $email . '</td></tr>
        <tr><th>Phone</th><td>' . $phone . '</td></tr>
        <tr><th>Date</th><td>' . $date . '</td></tr>
      </table>
    </body>
    </html>
    ';

    $headers = array('Content-Type: text/html; charset=UTF-8');

    // Send email BEFORE sending AJAX success
    wp_mail($recipient, $subject, $message, $headers);

    // Send JSON response back to JS
    wp_send_json_success([
        'message' => 'Booking submitted successfully!',
        'booking_id' => $booking_id
    ]);
// <--- Make sure this closing brace exists



    // Prepare HTML email
    $recipient = 'pvignesh.mca54@gmail.com';
    $subject = 'New Booking';
    $message = '
    <html>
    <head>
      <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
      </style>
    </head>
    <body>
      <h2>New Booking Received</h2>
      <table>
        <tr><th>Booking ID</th><td>' . $booking_id . '</td></tr>
        <tr><th>Services</th><td>' . $services_list . '</td></tr>
        <tr><th>Name</th><td>' . $name . '</td></tr>
        <tr><th>Email</th><td>' . $email . '</td></tr>
        <tr><th>Phone</th><td>' . $phone . '</td></tr>
        <tr><th>Date</th><td>' . $date . '</td></tr>
      </table>
    </body>
    </html>
    ';

    // Set content type to HTML
    $headers = array('Content-Type: text/html; charset=UTF-8');

    wp_mail($recipient, $subject, $message, $headers);

    wp_send_json_success('Booking submitted successfully!');
}


add_action('wp_ajax_custom_booking', 'handle_custom_booking_ajax');
add_action('wp_ajax_nopriv_custom_booking', 'handle_custom_booking_ajax');


// ------------------------------
// 7️⃣ AJAX: Get products by category
// ------------------------------
add_action('wp_ajax_get_category_products', 'get_category_products');
add_action('wp_ajax_nopriv_get_category_products', 'get_category_products');

function get_category_products() {
    $product_id = intval($_POST['product_id'] ?? 0);
    if(!$product_id) wp_send_json_error('Invalid product');

    $categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
    if(!$categories) wp_send_json_error('No category found');

    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $categories,
            )
        )
    );

    $products = get_posts($args);
    $html = '';
    foreach($products as $product){
        $html .= '<label class="custom-checkbox">
            <input type="checkbox" name="services[]" value="' . esc_attr($product->post_title) . '"> 
            <span>' . esc_html($product->post_title) . '</span>
          </label>';
    }

    wp_send_json_success($html);
}


// ------------------------------
// 8️⃣ Preload category products for faster popup
// ------------------------------
add_action('wp_footer', function() {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'post_status' => 'publish',
    );

    $products = get_posts($args);
    $category_products = array();

    foreach($products as $product){
        $cats = wp_get_post_terms($product->ID, 'product_cat', array('fields'=>'ids'));
        foreach($cats as $cat_id){
            $category_products[$cat_id][] = array(
                'id' => $product->ID,
                'title' => $product->post_title
            );
        }
    }
    ?>
    <script>
    var categoryProducts = <?php echo wp_json_encode($category_products); ?>;
    </script>
    <?php
});


// Load Google Fonts - Poppins
function load_poppins_font() {
    wp_enqueue_style(
        'poppins-font',
        'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap',
        false,
        null
    );
}
add_action('wp_enqueue_scripts', 'load_poppins_font');

