jQuery(document).ready(function($){

    // Initialize Flatpickr
    if(typeof flatpickr !== "undefined"){
        flatpickr("#booking-date", {
            dateFormat: "Y-m-d",
            minDate: new Date().fp_incr(2)
        });
    }

    // Pre-check a product when popup opens from Book Now
    $(document).on("click", ".book-now", function(e){
        e.preventDefault();
        var productName = $(this).data("product");
        var popupId = $(this).data("popup");
        if(!productName || !popupId) return;

        // Open Popup Maker
        if(typeof PUM !== "undefined" && PUM.open){
            PUM.open(popupId);
        } else {
            $("#pum-" + popupId).show().addClass("pum-open");
        }

        // Pre-check the clicked product in the popup
        var $popup = $("#pum-" + popupId);
        var $checkbox = $popup.find("input[name='services[]'][value='" + productName + "']");
        if($checkbox.length) $checkbox.prop("checked", true);
    });

    // AJAX form submission
    $(document).on("submit", "#custom-booking-form", function(e){
        e.preventDefault();
        var $form = $(this);

        // Validate at least one service is selected
        if($form.find("input[name='services[]']:checked").length === 0){
            alert("Please select at least one service.");
            return;
        }

        $.ajax({
            url: custom_booking_ajax.ajax_url,
            method: "POST",
            data: $form.serialize() + "&action=custom_booking",
            success: function(res){
                if(res.success){
                    alert(res.data);

                    // WhatsApp message
                    var services = [];
                    $form.find("input[name='services[]']:checked").each(function(){ 
                        services.push($(this).val()); 
                    });
                    var whatsappMessage = "New booking:\nService(s): " + services.join(", ") +
                                          "\nName: " + $form.find("input[name='name']").val() +
                                          "\nEmail: " + $form.find("input[name='email']").val() +
                                          "\nPhone: " + $form.find("input[name='phone']").val() +
                                          "\nDate: " + $form.find("input[name='date']").val();

                    // Replace with your WhatsApp number (international format)
                    window.open("https://wa.me/91XXXXXXXXXX?text=" + encodeURIComponent(whatsappMessage), "_blank");

                    // Reset form
                    $form[0].reset();

                    // Close popup
                    $form.closest(".pum").removeClass("pum-open").hide();
                } else {
                    alert(res.data);
                }
            },
            error: function(){
                alert("An error occurred. Please try again.");
            }
        });
    });

});
