<?php
/**
 * @package     WordPress
 * @subpackage  Luxury Spa Child
 * @version     1.2.0
 */

// Enqueue child theme style
function luxury_spa_enqueue_styles() {
    wp_enqueue_style('luxury-spa-child-style', get_stylesheet_uri(), array(), '1.2.0', 'screen, print');
}
add_action('wp_enqueue_scripts', 'luxury_spa_enqueue_styles', 11);

// Replace WooCommerce “Add to Cart” button with "Book Now"
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action('woocommerce_after_shop_loop_item', 'custom_book_now_button', 10);
function custom_book_now_button() {
    global $product;
    if (!$product || !is_a($product, 'WC_Product')) return;

    $popup_id = 14176; // Change to your actual Popup Maker ID
    $product_name = esc_attr($product->get_name());

    echo '<a href="#" 
        class="button book-now pum-trigger" 
        data-popup="' . esc_attr($popup_id) . '" 
        data-product="' . $product_name . '" 
        style="cursor:pointer; display:inline-block; margin-top:10px;">
        Book Now
      </a>';
}

// Create custom bookings table
function create_custom_bookings_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'custom_bookings';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        services text NOT NULL,
        name varchar(255) NOT NULL,
        email varchar(255) NOT NULL,
        phone varchar(50) NOT NULL,
        date date NOT NULL,
        created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
add_action('after_setup_theme', 'create_custom_bookings_table');

// Enqueue scripts and styles
function enqueue_custom_booking_scripts() {
    wp_enqueue_script('jquery-ui-datepicker');
    wp_enqueue_style('jquery-ui-css', 'https://code.jquery.com/ui/1.13.2/themes/smoothness/jquery-ui.css');

    wp_enqueue_script('flatpickr-js', 'https://cdn.jsdelivr.net/npm/flatpickr', array('jquery'), null, true);
    wp_enqueue_style('flatpickr-css', 'https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css');

    wp_enqueue_script(
        'custom-booking-js',
        get_stylesheet_directory_uri() . '/js/custom-booking.js',
        array('jquery', 'popup-maker-site', 'flatpickr-js'),
        '1.5',
        true
    );

    wp_localize_script(
        'custom-booking-js',
        'custom_booking_ajax',
        array('ajax_url' => admin_url('admin-ajax.php'))
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_booking_scripts');

// Booking form shortcode
// Booking form shortcode with dynamic multi-product selection
function custom_booking_form_shortcode() {
    global $wpdb;

    // Get all published WooCommerce products
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'post_status' => 'publish'
    );
    $products = get_posts($args);

    ob_start(); ?>
    <form id="custom-booking-form" class="custom-booking-ajax" method="post">
        <p><strong>Select Services:</strong></p>
        <div id="services-list">
            <?php foreach($products as $product): ?>
                <label>
                    <input type="checkbox" name="services[]" value="<?php echo esc_attr($product->post_title); ?>">
                    <?php echo esc_html($product->post_title); ?>
                </label><br>
            <?php endforeach; ?>
        </div>

        <label for="date">Select Date</label>
        <input type="text" name="date" id="booking-date" placeholder="Select your date" required>

        <label for="name">Full Name</label>
        <input type="text" name="name" required>

        <label for="email">Email</label>
        <input type="email" name="email" required>

        <label for="phone">Phone</label>
        <input type="tel" name="phone" required>

        <button type="submit" name="submit_booking">Confirm Booking</button>
    </form>
    <div id="booking-message" style="margin-top:10px;color:green;"></div>
    <?php
    return ob_get_clean();
}
add_shortcode('custom_booking_form', 'custom_booking_form_shortcode');


// AJAX booking handler
function handle_custom_booking_ajax() {
    global $wpdb;
    $table = $wpdb->prefix . 'custom_bookings';

    $services = $_POST['services'] ?? [];
    $name     = sanitize_text_field($_POST['name'] ?? '');
    $email    = sanitize_email($_POST['email'] ?? '');
    $phone    = sanitize_text_field($_POST['phone'] ?? '');
    $date     = sanitize_text_field($_POST['date'] ?? '');

    if(empty($services) || empty($name) || empty($email) || empty($phone) || empty($date)){
        wp_send_json_error('Please fill in all fields.');
    }

    $services_list = implode(', ', array_map('sanitize_text_field', $services));

    $wpdb->insert($table, [
        'services' => $services_list,
        'name' => $name,
        'email' => $email,
        'phone' => $phone,
        'date' => $date,
        'created_at' => current_time('mysql')
    ]);

    // Send email
    $recipient = 'pvignesh.mca54@gmail.com'; // <-- Replace with your email
    wp_mail(
        $recipient,
        'New Booking',
        "New booking:\nServices: $services_list\nName: $name\nEmail: $email\nPhone: $phone\nDate: $date"
    );

    wp_send_json_success('Booking submitted successfully!');
}
add_action('wp_ajax_custom_booking', 'handle_custom_booking_ajax');
add_action('wp_ajax_nopriv_custom_booking', 'handle_custom_booking_ajax');
