jQuery(document).ready(function($){

    var selectedServices = [];

    // Initialize Flatpickr
    if(typeof flatpickr !== "undefined"){
        flatpickr("#booking-date", {
            dateFormat: "Y-m-d",
            minDate: new Date().fp_incr(2),
            disable: [function(date){ return date.getDay() === 0; }]
        });
    }

    // Open popup and load products
    $(document).on("click", ".book-now", function(e){
        e.preventDefault();
        var $btn = $(this);
        var popupId = $btn.data("popup");
        var categoryId = $btn.data("category-id");
        var productName = $btn.data("product");
        if(!popupId || !categoryId) return;

        var $popup = $("#pum-" + popupId);
        var products = categoryProducts[categoryId] || [];
        var html = '';
        products.forEach(function(p){
            var checked = selectedServices.includes(p.title) ? 'checked' : '';
            html += '<label><input type="checkbox" name="services[]" value="' + p.title + '" ' + checked + '> ' + p.title + '</label><br>';
        });
        $popup.find("#services-list").html(html);

        if(!selectedServices.includes(productName)) selectedServices.push(productName);
        $popup.find("input[name='services[]'][value='" + productName + "']").prop("checked", true);

        if(typeof PUM !== "undefined" && PUM.open){
            PUM.open(popupId);
        } else {
            $popup.show().addClass("pum-open");
        }
    });

    // Update selectedServices
    $(document).on("change", "#custom-booking-form input[name='services[]']", function(){
        var service = $(this).val();
        if($(this).is(":checked")){
            if(!selectedServices.includes(service)) selectedServices.push(service);
        } else {
            selectedServices = selectedServices.filter(s => s !== service);
        }
    });

    // Close popup
    $(document).on("click", ".pum-close", function(){
        $(this).closest(".pum").removeClass("pum-open").hide();
    });

    // AJAX form submission with loader
    $(document).on("submit", "#custom-booking-form", function(e){
        e.preventDefault();
        var $form = $(this);
        var $button = $form.find("button[type='submit']");

        if($form.find("input[name='services[]']:checked").length === 0){
            alert("Please select at least one service.");
            return;
        }

        // Show loader in button
        $button.prop("disabled", true).html('<span class="spinner" style="margin-right:5px;">&#9696;</span>Submitting...');

        // Collect form data immediately
        var formData = $form.serialize();

        $.ajax({
            url: custom_booking_ajax.ajax_url,
            method: "POST",
            data: formData + "&action=custom_booking",
            success: function(res){
                if(res.success){

                    // Collect values for acknowledgment
                    var name = $form.find("input[name='name']").val();
                    var email = $form.find("input[name='email']").val();
                    var phone = $form.find("input[name='phone']").val();
                    var date = $form.find("input[name='date']").val();
                    var servicesSelected = [];
                    $form.find("input[name='services[]']:checked").each(function(){
                        servicesSelected.push($(this).val());
                    });

                    // Clear form immediately
                    $form[0].reset();
                    $form.find("input[type='checkbox']").prop('checked', false);
                    selectedServices = [];
                    $form.find("#services-list").html('');

                    // Hide form
                    $("#booking-form-wrapper").hide();

                    // Show acknowledgment
                    var ackMessage = '<h3>Thank you! Your booking has been submitted.</h3>';
                    var summaryHtml = '<table style="border-collapse: collapse; width: 100%;">' +
                                      '<tr><th>Booking ID</th><td>' + res.data.booking_id + '</td></tr>' +
                                      '<tr><th>Services</th><td>' + servicesSelected.join(', ') + '</td></tr>' +
                                      '<tr><th>Name</th><td>' + name + '</td></tr>' +
                                      '<tr><th>Email</th><td>' + email + '</td></tr>' +
                                      '<tr><th>Phone</th><td>' + phone + '</td></tr>' +
                                      '<tr><th>Date</th><td>' + date + '</td></tr>' +
                                      '</table>';

                    $("#booking-message").html(ackMessage + summaryHtml).css({
                        "color": "green",
                        "border": "1px solid #4CAF50",
                        "padding": "10px",
                        "border-radius": "5px",
                        "background-color": "#f0fff0",
                        "margin-bottom": "10px"
                    });

                    // Restore form after 10 seconds
                    setTimeout(function(){
                        $("#booking-message").html('');
                        $("#booking-form-wrapper").show();
                        $button.prop("disabled", false).text("Confirm Booking");
                    }, 10000);

                } else {
                    $("#booking-message").text(res.data).css("color","red");
                    $button.prop("disabled", false).text("Confirm Booking");
                }
            },
            error: function(){
                $("#booking-message").text("An error occurred. Please try again.").css("color","red");
                $button.prop("disabled", false).text("Confirm Booking");
            }
        });
    });

});
