<?php
/**
 * @package 	WordPress
 * @subpackage 	Luxury Spa
 * @version 	1.2.7
 * 
 * Admin Panel Scripts & Styles
 * Created by CMSMasters
 * 
 */


function luxury_spa_admin_register($hook) {
	global $pagenow;
	
	$screen = get_current_screen();
	
	
	wp_enqueue_style('wp-color-picker');
	
	wp_enqueue_script('wp-color-picker');

	wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', array(
		'clear' => 				esc_attr__('Clear', 'luxury-spa'),
		'clearAriaLabel' => 	esc_attr__('Clear color', 'luxury-spa'),
		'defaultLabel' => 		esc_attr__('Color value', 'luxury-spa'),
		'defaultString' => 		esc_attr__('Default', 'luxury-spa'),
		'defaultAriaLabel' => 	esc_attr__('Select default color', 'luxury-spa'),
		'pick' => 				esc_attr__('Select Color', 'luxury-spa'),
	) ); 
	
	wp_enqueue_script('wp-color-picker-alpha', get_template_directory_uri() . '/framework/admin/inc/js/wp-color-picker-alpha.js', array('jquery', 'wp-color-picker'), '3.0.4', true);
	
	
	wp_enqueue_style('luxury-spa-admin-icons-font', get_template_directory_uri() . '/framework/admin/inc/css/admin-icons-font.css', array(), '1.0.0', 'screen');
	
	wp_enqueue_style('luxury-spa-lightbox', get_template_directory_uri() . '/framework/admin/inc/css/jquery.cmsmastersLightbox.css', array(), '1.0.0', 'screen');
	
	if (is_rtl()) {
		wp_enqueue_style('luxury-spa-lightbox-rtl', get_template_directory_uri() . '/framework/admin/inc/css/jquery.cmsmastersLightbox-rtl.css', array(), '1.0.0', 'screen');
	}
	
	
	wp_enqueue_script('luxury-spa-uploader-js', get_template_directory_uri() . '/framework/admin/inc/js/jquery.cmsmastersUploader.js', array('jquery'), '1.0.0', true);
	
	wp_localize_script('luxury-spa-uploader-js', 'cmsmasters_admin_uploader', array( 
		'choose' => 				esc_attr__('Choose image', 'luxury-spa'), 
		'insert' => 				esc_attr__('Insert image', 'luxury-spa'), 
		'remove' => 				esc_attr__('Remove', 'luxury-spa'), 
		'edit_gallery' => 			esc_attr__('Edit gallery', 'luxury-spa') 
	));
	
	
	wp_enqueue_script('luxury-spa-lightbox-js', get_template_directory_uri() . '/framework/admin/inc/js/jquery.cmsmastersLightbox.js', array('jquery'), '1.0.0', true);
	
	wp_localize_script('luxury-spa-lightbox-js', 'cmsmasters_admin_lightbox', array( 
		'cancel' => 				esc_attr__('Cancel', 'luxury-spa'), 
		'insert' => 				esc_attr__('Insert', 'luxury-spa'), 
		'deselect' => 				esc_attr__('Deselect', 'luxury-spa'), 
		'choose_icon' => 			esc_attr__('Choose Icon', 'luxury-spa'), 
		'find_icons' => 			esc_attr__('Find icons', 'luxury-spa'), 
		'min_length' => 			esc_attr__('min 2 symbols', 'luxury-spa'), 
		'choose_font' => 			esc_attr__('Choose icons font', 'luxury-spa'), 
		'error_on_page' => 			esc_attr__("Error on page!\nReload page and try again.", 'luxury-spa') 
	));
	
	
	if ( 
		$hook == 'post.php' || 
		$hook == 'post-new.php' || 
		$hook == 'widgets.php' || 
		$hook == 'term.php' || 
		$hook == 'edit-tags.php' || 
		$hook == 'nav-menus.php' || 
		str_replace('cmsmasters-settings-element', '', $screen->id) != $screen->id 
	) {
		wp_enqueue_style('luxury-spa-icons', get_template_directory_uri() . '/css/fontello.css', array(), '1.0.0', 'screen');
		
		wp_enqueue_style('luxury-spa-icons-custom', get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/css/fontello-custom.css', array(), '1.0.0', 'screen');
	}
	
	
	if ( 
		$hook == 'widgets.php' || 
		$hook == 'nav-menus.php' 
	) {
		wp_enqueue_media();
	}
	
	
	wp_enqueue_style('luxury-spa-admin-styles', get_template_directory_uri() . '/framework/admin/inc/css/admin-theme-styles.css', array(), '1.0.0', 'screen');
	
	if (is_rtl()) {
		wp_enqueue_style('luxury-spa-admin-styles-rtl', get_template_directory_uri() . '/framework/admin/inc/css/admin-theme-styles-rtl.css', array(), '1.0.0', 'screen');
	}
	
	
	wp_enqueue_script('luxury-spa-admin-scripts', get_template_directory_uri() . '/framework/admin/inc/js/admin-theme-scripts.js', array('jquery'), '1.0.0', true);
	
	
	if ($hook == 'widgets.php') {
		wp_enqueue_style('luxury-spa-widgets-styles', get_template_directory_uri() . '/framework/admin/inc/css/widgets-styles.css', array(), '1.0.0', 'screen');
		
		wp_enqueue_script('luxury-spa-widgets-scripts', get_template_directory_uri() . '/framework/admin/inc/js/widgets-scripts.js', array('jquery'), '1.0.0', true);
	}
}

add_action('admin_enqueue_scripts', 'luxury_spa_admin_register');

add_action('admin_enqueue_scripts', 'cmsmasters_composer_icons');

